/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.chime.endpoints.ChimeEndpointParams;
import software.amazon.awssdk.services.chime.endpoints.ChimeEndpointProvider;
import software.amazon.awssdk.services.chime.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class ChimeResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        ChimeEndpointProvider provider = (ChimeEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(ChimeResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = ChimeResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static ChimeEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        ChimeEndpointParams.Builder builder = ChimeEndpointParams.builder();
        ChimeResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        ChimeResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        return builder.build();
    }

    private static void setContextParams(ChimeEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(ChimeEndpointParams.Builder params, String operationName) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "BatchCreateChannelMembership": {
                return Optional.of("messaging-");
            }
            case "CreateAppInstance": {
                return Optional.of("identity-");
            }
            case "CreateAppInstanceAdmin": {
                return Optional.of("identity-");
            }
            case "CreateAppInstanceUser": {
                return Optional.of("identity-");
            }
            case "CreateChannel": {
                return Optional.of("messaging-");
            }
            case "CreateChannelBan": {
                return Optional.of("messaging-");
            }
            case "CreateChannelMembership": {
                return Optional.of("messaging-");
            }
            case "CreateChannelModerator": {
                return Optional.of("messaging-");
            }
            case "DeleteAppInstance": {
                return Optional.of("identity-");
            }
            case "DeleteAppInstanceAdmin": {
                return Optional.of("identity-");
            }
            case "DeleteAppInstanceUser": {
                return Optional.of("identity-");
            }
            case "DeleteChannel": {
                return Optional.of("messaging-");
            }
            case "DeleteChannelBan": {
                return Optional.of("messaging-");
            }
            case "DeleteChannelMembership": {
                return Optional.of("messaging-");
            }
            case "DeleteChannelMessage": {
                return Optional.of("messaging-");
            }
            case "DeleteChannelModerator": {
                return Optional.of("messaging-");
            }
            case "DescribeAppInstance": {
                return Optional.of("identity-");
            }
            case "DescribeAppInstanceAdmin": {
                return Optional.of("identity-");
            }
            case "DescribeAppInstanceUser": {
                return Optional.of("identity-");
            }
            case "DescribeChannel": {
                return Optional.of("messaging-");
            }
            case "DescribeChannelBan": {
                return Optional.of("messaging-");
            }
            case "DescribeChannelMembership": {
                return Optional.of("messaging-");
            }
            case "DescribeChannelMembershipForAppInstanceUser": {
                return Optional.of("messaging-");
            }
            case "DescribeChannelModeratedByAppInstanceUser": {
                return Optional.of("messaging-");
            }
            case "DescribeChannelModerator": {
                return Optional.of("messaging-");
            }
            case "GetAppInstanceRetentionSettings": {
                return Optional.of("identity-");
            }
            case "GetChannelMessage": {
                return Optional.of("messaging-");
            }
            case "GetMessagingSessionEndpoint": {
                return Optional.of("messaging-");
            }
            case "ListAppInstanceAdmins": {
                return Optional.of("identity-");
            }
            case "ListAppInstanceUsers": {
                return Optional.of("identity-");
            }
            case "ListAppInstances": {
                return Optional.of("identity-");
            }
            case "ListChannelBans": {
                return Optional.of("messaging-");
            }
            case "ListChannelMemberships": {
                return Optional.of("messaging-");
            }
            case "ListChannelMembershipsForAppInstanceUser": {
                return Optional.of("messaging-");
            }
            case "ListChannelMessages": {
                return Optional.of("messaging-");
            }
            case "ListChannelModerators": {
                return Optional.of("messaging-");
            }
            case "ListChannels": {
                return Optional.of("messaging-");
            }
            case "ListChannelsModeratedByAppInstanceUser": {
                return Optional.of("messaging-");
            }
            case "PutAppInstanceRetentionSettings": {
                return Optional.of("identity-");
            }
            case "RedactChannelMessage": {
                return Optional.of("messaging-");
            }
            case "SendChannelMessage": {
                return Optional.of("messaging-");
            }
            case "UpdateAppInstance": {
                return Optional.of("identity-");
            }
            case "UpdateAppInstanceUser": {
                return Optional.of("identity-");
            }
            case "UpdateChannel": {
                return Optional.of("messaging-");
            }
            case "UpdateChannelMessage": {
                return Optional.of("messaging-");
            }
            case "UpdateChannelReadMarker": {
                return Optional.of("messaging-");
            }
        }
        return Optional.empty();
    }
}

