/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.CountryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutVoiceConnectorProxyRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutVoiceConnectorProxyRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(PutVoiceConnectorProxyRequest.getter(PutVoiceConnectorProxyRequest::voiceConnectorId)).setter(PutVoiceConnectorProxyRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<Integer> DEFAULT_SESSION_EXPIRY_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultSessionExpiryMinutes").getter(PutVoiceConnectorProxyRequest.getter(PutVoiceConnectorProxyRequest::defaultSessionExpiryMinutes)).setter(PutVoiceConnectorProxyRequest.setter(Builder::defaultSessionExpiryMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSessionExpiryMinutes").build()}).build();
    private static final SdkField<List<String>> PHONE_NUMBER_POOL_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberPoolCountries").getter(PutVoiceConnectorProxyRequest.getter(PutVoiceConnectorProxyRequest::phoneNumberPoolCountries)).setter(PutVoiceConnectorProxyRequest.setter(Builder::phoneNumberPoolCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberPoolCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FALL_BACK_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FallBackPhoneNumber").getter(PutVoiceConnectorProxyRequest.getter(PutVoiceConnectorProxyRequest::fallBackPhoneNumber)).setter(PutVoiceConnectorProxyRequest.setter(Builder::fallBackPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallBackPhoneNumber").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(PutVoiceConnectorProxyRequest.getter(PutVoiceConnectorProxyRequest::disabled)).setter(PutVoiceConnectorProxyRequest.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, DEFAULT_SESSION_EXPIRY_MINUTES_FIELD, PHONE_NUMBER_POOL_COUNTRIES_FIELD, FALL_BACK_PHONE_NUMBER_FIELD, DISABLED_FIELD));
    private final String voiceConnectorId;
    private final Integer defaultSessionExpiryMinutes;
    private final List<String> phoneNumberPoolCountries;
    private final String fallBackPhoneNumber;
    private final Boolean disabled;

    private PutVoiceConnectorProxyRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.defaultSessionExpiryMinutes = builder.defaultSessionExpiryMinutes;
        this.phoneNumberPoolCountries = builder.phoneNumberPoolCountries;
        this.fallBackPhoneNumber = builder.fallBackPhoneNumber;
        this.disabled = builder.disabled;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final Integer defaultSessionExpiryMinutes() {
        return this.defaultSessionExpiryMinutes;
    }

    public final boolean hasPhoneNumberPoolCountries() {
        return this.phoneNumberPoolCountries != null && !(this.phoneNumberPoolCountries instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumberPoolCountries() {
        return this.phoneNumberPoolCountries;
    }

    public final String fallBackPhoneNumber() {
        return this.fallBackPhoneNumber;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSessionExpiryMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberPoolCountries() ? this.phoneNumberPoolCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fallBackPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorProxyRequest)) {
            return false;
        }
        PutVoiceConnectorProxyRequest other = (PutVoiceConnectorProxyRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.defaultSessionExpiryMinutes(), other.defaultSessionExpiryMinutes()) && this.hasPhoneNumberPoolCountries() == other.hasPhoneNumberPoolCountries() && Objects.equals(this.phoneNumberPoolCountries(), other.phoneNumberPoolCountries()) && Objects.equals(this.fallBackPhoneNumber(), other.fallBackPhoneNumber()) && Objects.equals(this.disabled(), other.disabled());
    }

    public final String toString() {
        return ToString.builder((String)"PutVoiceConnectorProxyRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("DefaultSessionExpiryMinutes", (Object)this.defaultSessionExpiryMinutes()).add("PhoneNumberPoolCountries", this.hasPhoneNumberPoolCountries() ? this.phoneNumberPoolCountries() : null).add("FallBackPhoneNumber", (Object)(this.fallBackPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Disabled", (Object)this.disabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "DefaultSessionExpiryMinutes": {
                return Optional.ofNullable(clazz.cast(this.defaultSessionExpiryMinutes()));
            }
            case "PhoneNumberPoolCountries": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberPoolCountries()));
            }
            case "FallBackPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.fallBackPhoneNumber()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorProxyRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorProxyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private Integer defaultSessionExpiryMinutes;
        private List<String> phoneNumberPoolCountries = DefaultSdkAutoConstructList.getInstance();
        private String fallBackPhoneNumber;
        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorProxyRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.defaultSessionExpiryMinutes(model.defaultSessionExpiryMinutes);
            this.phoneNumberPoolCountries(model.phoneNumberPoolCountries);
            this.fallBackPhoneNumber(model.fallBackPhoneNumber);
            this.disabled(model.disabled);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final Integer getDefaultSessionExpiryMinutes() {
            return this.defaultSessionExpiryMinutes;
        }

        public final void setDefaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
        }

        @Override
        public final Builder defaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
            return this;
        }

        public final Collection<String> getPhoneNumberPoolCountries() {
            if (this.phoneNumberPoolCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberPoolCountries;
        }

        public final void setPhoneNumberPoolCountries(Collection<String> phoneNumberPoolCountries) {
            this.phoneNumberPoolCountries = CountryListCopier.copy(phoneNumberPoolCountries);
        }

        @Override
        public final Builder phoneNumberPoolCountries(Collection<String> phoneNumberPoolCountries) {
            this.phoneNumberPoolCountries = CountryListCopier.copy(phoneNumberPoolCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberPoolCountries(String ... phoneNumberPoolCountries) {
            this.phoneNumberPoolCountries(Arrays.asList(phoneNumberPoolCountries));
            return this;
        }

        public final String getFallBackPhoneNumber() {
            return this.fallBackPhoneNumber;
        }

        public final void setFallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
        }

        @Override
        public final Builder fallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorProxyRequest build() {
            return new PutVoiceConnectorProxyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutVoiceConnectorProxyRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder defaultSessionExpiryMinutes(Integer var1);

        public Builder phoneNumberPoolCountries(Collection<String> var1);

        public Builder phoneNumberPoolCountries(String ... var1);

        public Builder fallBackPhoneNumber(String var1);

        public Builder disabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

