/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.RoomMembershipRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MembershipItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MembershipItem> {
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(MembershipItem.getter(MembershipItem::memberId)).setter(MembershipItem.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(MembershipItem.getter(MembershipItem::roleAsString)).setter(MembershipItem.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ID_FIELD, ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String memberId;
    private final String role;

    private MembershipItem(BuilderImpl builder) {
        this.memberId = builder.memberId;
        this.role = builder.role;
    }

    public final String memberId() {
        return this.memberId;
    }

    public final RoomMembershipRole role() {
        return RoomMembershipRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipItem)) {
            return false;
        }
        MembershipItem other = (MembershipItem)obj;
        return Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.roleAsString(), other.roleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MembershipItem").add("MemberId", (Object)this.memberId()).add("Role", (Object)this.roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MembershipItem, T> g) {
        return obj -> g.apply((MembershipItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memberId;
        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipItem model) {
            this.memberId(model.memberId);
            this.role(model.role);
        }

        public final String getMemberId() {
            return this.memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        @Transient
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        @Transient
        public final Builder role(RoomMembershipRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public MembershipItem build() {
            return new MembershipItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MembershipItem> {
        public Builder memberId(String var1);

        public Builder role(String var1);

        public Builder role(RoomMembershipRole var1);
    }
}

