/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationTarget {
    EVENT_BRIDGE("EventBridge"),
    SNS("SNS"),
    SQS("SQS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationTarget> VALUE_MAP;
    private final String value;

    private NotificationTarget(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationTarget fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationTarget> knownValues() {
        EnumSet<NotificationTarget> knownValues = EnumSet.allOf(NotificationTarget.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationTarget.class, NotificationTarget::toString);
    }
}

