/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorsResponse;

public class ListVoiceConnectorsIterable
implements SdkIterable<ListVoiceConnectorsResponse> {
    private final ChimeClient client;
    private final ListVoiceConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVoiceConnectorsIterable(ChimeClient client, ListVoiceConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVoiceConnectorsResponseFetcher();
    }

    public Iterator<ListVoiceConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVoiceConnectorsResponseFetcher
    implements SyncPageFetcher<ListVoiceConnectorsResponse> {
        private ListVoiceConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVoiceConnectorsResponse nextPage(ListVoiceConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceConnectorsIterable.this.client.listVoiceConnectors(ListVoiceConnectorsIterable.this.firstRequest);
            }
            return ListVoiceConnectorsIterable.this.client.listVoiceConnectors((ListVoiceConnectorsRequest)((Object)ListVoiceConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

