/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoMatchParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoMatchParams> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(GeoMatchParams.getter(GeoMatchParams::country)).setter(GeoMatchParams.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> AREA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AreaCode").getter(GeoMatchParams.getter(GeoMatchParams::areaCode)).setter(GeoMatchParams.setter(Builder::areaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, AREA_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String country;
    private final String areaCode;

    private GeoMatchParams(BuilderImpl builder) {
        this.country = builder.country;
        this.areaCode = builder.areaCode;
    }

    public final String country() {
        return this.country;
    }

    public final String areaCode() {
        return this.areaCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.areaCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchParams)) {
            return false;
        }
        GeoMatchParams other = (GeoMatchParams)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.areaCode(), other.areaCode());
    }

    public final String toString() {
        return ToString.builder((String)"GeoMatchParams").add("Country", (Object)this.country()).add("AreaCode", (Object)this.areaCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "AreaCode": {
                return Optional.ofNullable(clazz.cast(this.areaCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchParams, T> g) {
        return obj -> g.apply((GeoMatchParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String country;
        private String areaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchParams model) {
            this.country(model.country);
            this.areaCode(model.areaCode);
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        @Transient
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getAreaCode() {
            return this.areaCode;
        }

        public final void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        @Override
        @Transient
        public final Builder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public GeoMatchParams build() {
            return new GeoMatchParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoMatchParams> {
        public Builder country(String var1);

        public Builder areaCode(String var1);
    }
}

