/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.LoggingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutVoiceConnectorLoggingConfigurationRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutVoiceConnectorLoggingConfigurationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(PutVoiceConnectorLoggingConfigurationRequest.getter(PutVoiceConnectorLoggingConfigurationRequest::voiceConnectorId)).setter(PutVoiceConnectorLoggingConfigurationRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(PutVoiceConnectorLoggingConfigurationRequest.getter(PutVoiceConnectorLoggingConfigurationRequest::loggingConfiguration)).setter(PutVoiceConnectorLoggingConfigurationRequest.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, LOGGING_CONFIGURATION_FIELD));
    private final String voiceConnectorId;
    private final LoggingConfiguration loggingConfiguration;

    private PutVoiceConnectorLoggingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.loggingConfiguration = builder.loggingConfiguration;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorLoggingConfigurationRequest)) {
            return false;
        }
        PutVoiceConnectorLoggingConfigurationRequest other = (PutVoiceConnectorLoggingConfigurationRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutVoiceConnectorLoggingConfigurationRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorLoggingConfigurationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorLoggingConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private LoggingConfiguration loggingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorLoggingConfigurationRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.loggingConfiguration(model.loggingConfiguration);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        @Transient
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorLoggingConfigurationRequest build() {
            return new PutVoiceConnectorLoggingConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutVoiceConnectorLoggingConfigurationRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

