/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListChannelMembershipsRequest;
import software.amazon.awssdk.services.chime.model.ListChannelMembershipsResponse;

public class ListChannelMembershipsIterable
implements SdkIterable<ListChannelMembershipsResponse> {
    private final ChimeClient client;
    private final ListChannelMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelMembershipsIterable(ChimeClient client, ListChannelMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChannelMembershipsResponseFetcher();
    }

    public Iterator<ListChannelMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelMembershipsResponseFetcher
    implements SyncPageFetcher<ListChannelMembershipsResponse> {
        private ListChannelMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelMembershipsResponse nextPage(ListChannelMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelMembershipsIterable.this.client.listChannelMemberships(ListChannelMembershipsIterable.this.firstRequest);
            }
            return ListChannelMembershipsIterable.this.client.listChannelMemberships((ListChannelMembershipsRequest)((Object)ListChannelMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

