/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TranscribeLanguageCode {
    EN_US("en-US"),
    EN_GB("en-GB"),
    ES_US("es-US"),
    FR_CA("fr-CA"),
    FR_FR("fr-FR"),
    EN_AU("en-AU"),
    IT_IT("it-IT"),
    DE_DE("de-DE"),
    PT_BR("pt-BR"),
    JA_JP("ja-JP"),
    KO_KR("ko-KR"),
    ZH_CN("zh-CN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TranscribeLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TranscribeLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TranscribeLanguageCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TranscribeLanguageCode> knownValues() {
        return Stream.of(TranscribeLanguageCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

