/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChannelModeratorSummary;
import software.amazon.awssdk.services.chime.model.ChannelModeratorSummaryListCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelModeratorsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListChannelModeratorsResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ListChannelModeratorsResponse.getter(ListChannelModeratorsResponse::channelArn)).setter(ListChannelModeratorsResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelModeratorsResponse.getter(ListChannelModeratorsResponse::nextToken)).setter(ListChannelModeratorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ChannelModeratorSummary>> CHANNEL_MODERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelModerators").getter(ListChannelModeratorsResponse.getter(ListChannelModeratorsResponse::channelModerators)).setter(ListChannelModeratorsResponse.setter(Builder::channelModerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelModerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelModeratorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, NEXT_TOKEN_FIELD, CHANNEL_MODERATORS_FIELD));
    private final String channelArn;
    private final String nextToken;
    private final List<ChannelModeratorSummary> channelModerators;

    private ListChannelModeratorsResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.nextToken = builder.nextToken;
        this.channelModerators = builder.channelModerators;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasChannelModerators() {
        return this.channelModerators != null && !(this.channelModerators instanceof SdkAutoConstructList);
    }

    public final List<ChannelModeratorSummary> channelModerators() {
        return this.channelModerators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelModerators() ? this.channelModerators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelModeratorsResponse)) {
            return false;
        }
        ListChannelModeratorsResponse other = (ListChannelModeratorsResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasChannelModerators() == other.hasChannelModerators() && Objects.equals(this.channelModerators(), other.channelModerators());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelModeratorsResponse").add("ChannelArn", (Object)this.channelArn()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ChannelModerators", this.hasChannelModerators() ? this.channelModerators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ChannelModerators": {
                return Optional.ofNullable(clazz.cast(this.channelModerators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelModeratorsResponse, T> g) {
        return obj -> g.apply((ListChannelModeratorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private String nextToken;
        private List<ChannelModeratorSummary> channelModerators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelModeratorsResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.nextToken(model.nextToken);
            this.channelModerators(model.channelModerators);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChannelModeratorSummary.Builder> getChannelModerators() {
            List<ChannelModeratorSummary.Builder> result = ChannelModeratorSummaryListCopier.copyToBuilder(this.channelModerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelModerators(Collection<ChannelModeratorSummary.BuilderImpl> channelModerators) {
            this.channelModerators = ChannelModeratorSummaryListCopier.copyFromBuilder(channelModerators);
        }

        @Override
        @Transient
        public final Builder channelModerators(Collection<ChannelModeratorSummary> channelModerators) {
            this.channelModerators = ChannelModeratorSummaryListCopier.copy(channelModerators);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelModerators(ChannelModeratorSummary ... channelModerators) {
            this.channelModerators(Arrays.asList(channelModerators));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelModerators(Consumer<ChannelModeratorSummary.Builder> ... channelModerators) {
            this.channelModerators(Stream.of(channelModerators).map(c -> (ChannelModeratorSummary)((ChannelModeratorSummary.Builder)ChannelModeratorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListChannelModeratorsResponse build() {
            return new ListChannelModeratorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelModeratorsResponse> {
        public Builder channelArn(String var1);

        public Builder nextToken(String var1);

        public Builder channelModerators(Collection<ChannelModeratorSummary> var1);

        public Builder channelModerators(ChannelModeratorSummary ... var1);

        public Builder channelModerators(Consumer<ChannelModeratorSummary.Builder> ... var1);
    }
}

