/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListMeetingsRequest;
import software.amazon.awssdk.services.chime.model.ListMeetingsResponse;

public class ListMeetingsIterable
implements SdkIterable<ListMeetingsResponse> {
    private final ChimeClient client;
    private final ListMeetingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMeetingsIterable(ChimeClient client, ListMeetingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMeetingsResponseFetcher();
    }

    public Iterator<ListMeetingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMeetingsResponseFetcher
    implements SyncPageFetcher<ListMeetingsResponse> {
        private ListMeetingsResponseFetcher() {
        }

        public boolean hasNextPage(ListMeetingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMeetingsResponse nextPage(ListMeetingsResponse previousPage) {
            if (previousPage == null) {
                return ListMeetingsIterable.this.client.listMeetings(ListMeetingsIterable.this.firstRequest);
            }
            return ListMeetingsIterable.this.client.listMeetings((ListMeetingsRequest)((Object)ListMeetingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

