/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.RetentionSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRetentionSettingsRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutRetentionSettingsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PutRetentionSettingsRequest.getter(PutRetentionSettingsRequest::accountId)).setter(PutRetentionSettingsRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<RetentionSettings> RETENTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionSettings").getter(PutRetentionSettingsRequest.getter(PutRetentionSettingsRequest::retentionSettings)).setter(PutRetentionSettingsRequest.setter(Builder::retentionSettings)).constructor(RetentionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RETENTION_SETTINGS_FIELD));
    private final String accountId;
    private final RetentionSettings retentionSettings;

    private PutRetentionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.retentionSettings = builder.retentionSettings;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final RetentionSettings retentionSettings() {
        return this.retentionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionSettingsRequest)) {
            return false;
        }
        PutRetentionSettingsRequest other = (PutRetentionSettingsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.retentionSettings(), other.retentionSettings());
    }

    public final String toString() {
        return ToString.builder((String)"PutRetentionSettingsRequest").add("AccountId", (Object)this.accountId()).add("RetentionSettings", (Object)this.retentionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "RetentionSettings": {
                return Optional.ofNullable(clazz.cast(this.retentionSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRetentionSettingsRequest, T> g) {
        return obj -> g.apply((PutRetentionSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private RetentionSettings retentionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionSettingsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.retentionSettings(model.retentionSettings);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final RetentionSettings.Builder getRetentionSettings() {
            return this.retentionSettings != null ? this.retentionSettings.toBuilder() : null;
        }

        @Override
        public final Builder retentionSettings(RetentionSettings retentionSettings) {
            this.retentionSettings = retentionSettings;
            return this;
        }

        public final void setRetentionSettings(RetentionSettings.BuilderImpl retentionSettings) {
            this.retentionSettings = retentionSettings != null ? retentionSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionSettingsRequest build() {
            return new PutRetentionSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRetentionSettingsRequest> {
        public Builder accountId(String var1);

        public Builder retentionSettings(RetentionSettings var1);

        default public Builder retentionSettings(Consumer<RetentionSettings.Builder> retentionSettings) {
            return this.retentionSettings((RetentionSettings)((RetentionSettings.Builder)RetentionSettings.builder().applyMutation(retentionSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

