/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.AppInstanceAdminListCopier;
import software.amazon.awssdk.services.chime.model.AppInstanceAdminSummary;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppInstanceAdminsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListAppInstanceAdminsResponse> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(ListAppInstanceAdminsResponse.getter(ListAppInstanceAdminsResponse::appInstanceArn)).setter(ListAppInstanceAdminsResponse.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()}).build();
    private static final SdkField<List<AppInstanceAdminSummary>> APP_INSTANCE_ADMINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppInstanceAdmins").getter(ListAppInstanceAdminsResponse.getter(ListAppInstanceAdminsResponse::appInstanceAdmins)).setter(ListAppInstanceAdminsResponse.setter(Builder::appInstanceAdmins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceAdmins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppInstanceAdminSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppInstanceAdminsResponse.getter(ListAppInstanceAdminsResponse::nextToken)).setter(ListAppInstanceAdminsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, APP_INSTANCE_ADMINS_FIELD, NEXT_TOKEN_FIELD));
    private final String appInstanceArn;
    private final List<AppInstanceAdminSummary> appInstanceAdmins;
    private final String nextToken;

    private ListAppInstanceAdminsResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceAdmins = builder.appInstanceAdmins;
        this.nextToken = builder.nextToken;
    }

    public final String appInstanceArn() {
        return this.appInstanceArn;
    }

    public final boolean hasAppInstanceAdmins() {
        return this.appInstanceAdmins != null && !(this.appInstanceAdmins instanceof SdkAutoConstructList);
    }

    public final List<AppInstanceAdminSummary> appInstanceAdmins() {
        return this.appInstanceAdmins;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppInstanceAdmins() ? this.appInstanceAdmins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstanceAdminsResponse)) {
            return false;
        }
        ListAppInstanceAdminsResponse other = (ListAppInstanceAdminsResponse)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && this.hasAppInstanceAdmins() == other.hasAppInstanceAdmins() && Objects.equals(this.appInstanceAdmins(), other.appInstanceAdmins()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppInstanceAdminsResponse").add("AppInstanceArn", (Object)this.appInstanceArn()).add("AppInstanceAdmins", this.hasAppInstanceAdmins() ? this.appInstanceAdmins() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "AppInstanceAdmins": {
                return Optional.ofNullable(clazz.cast(this.appInstanceAdmins()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstanceAdminsResponse, T> g) {
        return obj -> g.apply((ListAppInstanceAdminsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private List<AppInstanceAdminSummary> appInstanceAdmins = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstanceAdminsResponse model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.appInstanceAdmins(model.appInstanceAdmins);
            this.nextToken(model.nextToken);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        public final Collection<AppInstanceAdminSummary.Builder> getAppInstanceAdmins() {
            if (this.appInstanceAdmins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appInstanceAdmins != null ? (Collection)this.appInstanceAdmins.stream().map(AppInstanceAdminSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder appInstanceAdmins(Collection<AppInstanceAdminSummary> appInstanceAdmins) {
            this.appInstanceAdmins = AppInstanceAdminListCopier.copy(appInstanceAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceAdmins(AppInstanceAdminSummary ... appInstanceAdmins) {
            this.appInstanceAdmins(Arrays.asList(appInstanceAdmins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceAdmins(Consumer<AppInstanceAdminSummary.Builder> ... appInstanceAdmins) {
            this.appInstanceAdmins(Stream.of(appInstanceAdmins).map(c -> (AppInstanceAdminSummary)((AppInstanceAdminSummary.Builder)AppInstanceAdminSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAppInstanceAdmins(Collection<AppInstanceAdminSummary.BuilderImpl> appInstanceAdmins) {
            this.appInstanceAdmins = AppInstanceAdminListCopier.copyFromBuilder(appInstanceAdmins);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppInstanceAdminsResponse build() {
            return new ListAppInstanceAdminsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppInstanceAdminsResponse> {
        public Builder appInstanceArn(String var1);

        public Builder appInstanceAdmins(Collection<AppInstanceAdminSummary> var1);

        public Builder appInstanceAdmins(AppInstanceAdminSummary ... var1);

        public Builder appInstanceAdmins(Consumer<AppInstanceAdminSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

