/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.Identity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelModeratorResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, CreateChannelModeratorResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(CreateChannelModeratorResponse.getter(CreateChannelModeratorResponse::channelArn)).setter(CreateChannelModeratorResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<Identity> CHANNEL_MODERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChannelModerator").getter(CreateChannelModeratorResponse.getter(CreateChannelModeratorResponse::channelModerator)).setter(CreateChannelModeratorResponse.setter(Builder::channelModerator)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelModerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CHANNEL_MODERATOR_FIELD));
    private final String channelArn;
    private final Identity channelModerator;

    private CreateChannelModeratorResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.channelModerator = builder.channelModerator;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final Identity channelModerator() {
        return this.channelModerator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelModerator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelModeratorResponse)) {
            return false;
        }
        CreateChannelModeratorResponse other = (CreateChannelModeratorResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.channelModerator(), other.channelModerator());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelModeratorResponse").add("ChannelArn", (Object)this.channelArn()).add("ChannelModerator", (Object)this.channelModerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "ChannelModerator": {
                return Optional.ofNullable(clazz.cast(this.channelModerator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelModeratorResponse, T> g) {
        return obj -> g.apply((CreateChannelModeratorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private Identity channelModerator;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelModeratorResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.channelModerator(model.channelModerator);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final Identity.Builder getChannelModerator() {
            return this.channelModerator != null ? this.channelModerator.toBuilder() : null;
        }

        @Override
        public final Builder channelModerator(Identity channelModerator) {
            this.channelModerator = channelModerator;
            return this;
        }

        public final void setChannelModerator(Identity.BuilderImpl channelModerator) {
            this.channelModerator = channelModerator != null ? channelModerator.build() : null;
        }

        @Override
        public CreateChannelModeratorResponse build() {
            return new CreateChannelModeratorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelModeratorResponse> {
        public Builder channelArn(String var1);

        public Builder channelModerator(Identity var1);

        default public Builder channelModerator(Consumer<Identity.Builder> channelModerator) {
            return this.channelModerator((Identity)((Identity.Builder)Identity.builder().applyMutation(channelModerator)).build());
        }
    }
}

