/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.CreateAttendeeRequestItem;
import software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequestItemListCopier;
import software.amazon.awssdk.services.chime.model.MeetingNotificationConfiguration;
import software.amazon.awssdk.services.chime.model.MeetingTagListCopier;
import software.amazon.awssdk.services.chime.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMeetingWithAttendeesRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateMeetingWithAttendeesRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::clientRequestToken)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalMeetingId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::externalMeetingId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::externalMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()}).build();
    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingHostId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::meetingHostId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::meetingHostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()}).build();
    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaRegion").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::mediaRegion)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::mediaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::tags)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MeetingNotificationConfiguration> NOTIFICATIONS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationsConfiguration").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::notificationsConfiguration)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::notificationsConfiguration)).constructor(MeetingNotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsConfiguration").build()}).build();
    private static final SdkField<List<CreateAttendeeRequestItem>> ATTENDEES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attendees").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::attendees)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::attendees)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAttendeeRequestItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, EXTERNAL_MEETING_ID_FIELD, MEETING_HOST_ID_FIELD, MEDIA_REGION_FIELD, TAGS_FIELD, NOTIFICATIONS_CONFIGURATION_FIELD, ATTENDEES_FIELD));
    private final String clientRequestToken;
    private final String externalMeetingId;
    private final String meetingHostId;
    private final String mediaRegion;
    private final List<Tag> tags;
    private final MeetingNotificationConfiguration notificationsConfiguration;
    private final List<CreateAttendeeRequestItem> attendees;

    private CreateMeetingWithAttendeesRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.externalMeetingId = builder.externalMeetingId;
        this.meetingHostId = builder.meetingHostId;
        this.mediaRegion = builder.mediaRegion;
        this.tags = builder.tags;
        this.notificationsConfiguration = builder.notificationsConfiguration;
        this.attendees = builder.attendees;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String externalMeetingId() {
        return this.externalMeetingId;
    }

    public final String meetingHostId() {
        return this.meetingHostId;
    }

    public final String mediaRegion() {
        return this.mediaRegion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final MeetingNotificationConfiguration notificationsConfiguration() {
        return this.notificationsConfiguration;
    }

    public final boolean hasAttendees() {
        return this.attendees != null && !(this.attendees instanceof SdkAutoConstructList);
    }

    public final List<CreateAttendeeRequestItem> attendees() {
        return this.attendees;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttendees() ? this.attendees() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingWithAttendeesRequest)) {
            return false;
        }
        CreateMeetingWithAttendeesRequest other = (CreateMeetingWithAttendeesRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.externalMeetingId(), other.externalMeetingId()) && Objects.equals(this.meetingHostId(), other.meetingHostId()) && Objects.equals(this.mediaRegion(), other.mediaRegion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.notificationsConfiguration(), other.notificationsConfiguration()) && this.hasAttendees() == other.hasAttendees() && Objects.equals(this.attendees(), other.attendees());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMeetingWithAttendeesRequest").add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ExternalMeetingId", (Object)(this.externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")).add("MeetingHostId", (Object)(this.meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaRegion", (Object)this.mediaRegion()).add("Tags", this.hasTags() ? this.tags() : null).add("NotificationsConfiguration", (Object)this.notificationsConfiguration()).add("Attendees", this.hasAttendees() ? this.attendees() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ExternalMeetingId": {
                return Optional.ofNullable(clazz.cast(this.externalMeetingId()));
            }
            case "MeetingHostId": {
                return Optional.ofNullable(clazz.cast(this.meetingHostId()));
            }
            case "MediaRegion": {
                return Optional.ofNullable(clazz.cast(this.mediaRegion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NotificationsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationsConfiguration()));
            }
            case "Attendees": {
                return Optional.ofNullable(clazz.cast(this.attendees()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingWithAttendeesRequest, T> g) {
        return obj -> g.apply((CreateMeetingWithAttendeesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String externalMeetingId;
        private String meetingHostId;
        private String mediaRegion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private MeetingNotificationConfiguration notificationsConfiguration;
        private List<CreateAttendeeRequestItem> attendees = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingWithAttendeesRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.externalMeetingId(model.externalMeetingId);
            this.meetingHostId(model.meetingHostId);
            this.mediaRegion(model.mediaRegion);
            this.tags(model.tags);
            this.notificationsConfiguration(model.notificationsConfiguration);
            this.attendees(model.attendees);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getExternalMeetingId() {
            return this.externalMeetingId;
        }

        @Override
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        public final String getMeetingHostId() {
            return this.meetingHostId;
        }

        @Override
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        public final String getMediaRegion() {
            return this.mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = MeetingTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = MeetingTagListCopier.copyFromBuilder(tags);
        }

        public final MeetingNotificationConfiguration.Builder getNotificationsConfiguration() {
            return this.notificationsConfiguration != null ? this.notificationsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationsConfiguration(MeetingNotificationConfiguration notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration;
            return this;
        }

        public final void setNotificationsConfiguration(MeetingNotificationConfiguration.BuilderImpl notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration != null ? notificationsConfiguration.build() : null;
        }

        public final Collection<CreateAttendeeRequestItem.Builder> getAttendees() {
            if (this.attendees instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attendees != null ? (Collection)this.attendees.stream().map(CreateAttendeeRequestItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attendees(Collection<CreateAttendeeRequestItem> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copy(attendees);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(CreateAttendeeRequestItem ... attendees) {
            this.attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... attendees) {
            this.attendees(Stream.of(attendees).map(c -> (CreateAttendeeRequestItem)((CreateAttendeeRequestItem.Builder)CreateAttendeeRequestItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttendees(Collection<CreateAttendeeRequestItem.BuilderImpl> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copyFromBuilder(attendees);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingWithAttendeesRequest build() {
            return new CreateMeetingWithAttendeesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMeetingWithAttendeesRequest> {
        public Builder clientRequestToken(String var1);

        public Builder externalMeetingId(String var1);

        public Builder meetingHostId(String var1);

        public Builder mediaRegion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder notificationsConfiguration(MeetingNotificationConfiguration var1);

        default public Builder notificationsConfiguration(Consumer<MeetingNotificationConfiguration.Builder> notificationsConfiguration) {
            return this.notificationsConfiguration((MeetingNotificationConfiguration)((MeetingNotificationConfiguration.Builder)MeetingNotificationConfiguration.builder().applyMutation(notificationsConfiguration)).build());
        }

        public Builder attendees(Collection<CreateAttendeeRequestItem> var1);

        public Builder attendees(CreateAttendeeRequestItem ... var1);

        public Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

