/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChannelMembershipType;
import software.amazon.awssdk.services.chime.model.Identity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelMembership
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelMembership> {
    private static final SdkField<Identity> INVITED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvitedBy").getter(ChannelMembership.getter(ChannelMembership::invitedBy)).setter(ChannelMembership.setter(Builder::invitedBy)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedBy").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ChannelMembership.getter(ChannelMembership::typeAsString)).setter(ChannelMembership.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Identity> MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Member").getter(ChannelMembership.getter(ChannelMembership::member)).setter(ChannelMembership.setter(Builder::member)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ChannelMembership.getter(ChannelMembership::channelArn)).setter(ChannelMembership.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ChannelMembership.getter(ChannelMembership::createdTimestamp)).setter(ChannelMembership.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(ChannelMembership.getter(ChannelMembership::lastUpdatedTimestamp)).setter(ChannelMembership.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITED_BY_FIELD, TYPE_FIELD, MEMBER_FIELD, CHANNEL_ARN_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Identity invitedBy;
    private final String type;
    private final Identity member;
    private final String channelArn;
    private final Instant createdTimestamp;
    private final Instant lastUpdatedTimestamp;

    private ChannelMembership(BuilderImpl builder) {
        this.invitedBy = builder.invitedBy;
        this.type = builder.type;
        this.member = builder.member;
        this.channelArn = builder.channelArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public Identity invitedBy() {
        return this.invitedBy;
    }

    public ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Identity member() {
        return this.member;
    }

    public String channelArn() {
        return this.channelArn;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMembership)) {
            return false;
        }
        ChannelMembership other = (ChannelMembership)obj;
        return Objects.equals(this.invitedBy(), other.invitedBy()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.member(), other.member()) && Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"ChannelMembership").add("InvitedBy", (Object)this.invitedBy()).add("Type", (Object)this.typeAsString()).add("Member", (Object)this.member()).add("ChannelArn", (Object)this.channelArn()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvitedBy": {
                return Optional.ofNullable(clazz.cast(this.invitedBy()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMembership, T> g) {
        return obj -> g.apply((ChannelMembership)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Identity invitedBy;
        private String type;
        private Identity member;
        private String channelArn;
        private Instant createdTimestamp;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMembership model) {
            this.invitedBy(model.invitedBy);
            this.type(model.type);
            this.member(model.member);
            this.channelArn(model.channelArn);
            this.createdTimestamp(model.createdTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final Identity.Builder getInvitedBy() {
            return this.invitedBy != null ? this.invitedBy.toBuilder() : null;
        }

        @Override
        public final Builder invitedBy(Identity invitedBy) {
            this.invitedBy = invitedBy;
            return this;
        }

        public final void setInvitedBy(Identity.BuilderImpl invitedBy) {
            this.invitedBy = invitedBy != null ? invitedBy.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Identity.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        @Override
        public final Builder member(Identity member) {
            this.member = member;
            return this;
        }

        public final void setMember(Identity.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public ChannelMembership build() {
            return new ChannelMembership(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelMembership> {
        public Builder invitedBy(Identity var1);

        default public Builder invitedBy(Consumer<Identity.Builder> invitedBy) {
            return this.invitedBy((Identity)((Identity.Builder)Identity.builder().applyMutation(invitedBy)).build());
        }

        public Builder type(String var1);

        public Builder type(ChannelMembershipType var1);

        public Builder member(Identity var1);

        default public Builder member(Consumer<Identity.Builder> member) {
            return this.member((Identity)((Identity.Builder)Identity.builder().applyMutation(member)).build());
        }

        public Builder channelArn(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

