/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.AttendeeTagListCopier;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagAttendeeRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, TagAttendeeRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(TagAttendeeRequest.getter(TagAttendeeRequest::meetingId)).setter(TagAttendeeRequest.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meetingId").build()}).build();
    private static final SdkField<String> ATTENDEE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttendeeId").getter(TagAttendeeRequest.getter(TagAttendeeRequest::attendeeId)).setter(TagAttendeeRequest.setter(Builder::attendeeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("attendeeId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TagAttendeeRequest.getter(TagAttendeeRequest::tags)).setter(TagAttendeeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, ATTENDEE_ID_FIELD, TAGS_FIELD));
    private final String meetingId;
    private final String attendeeId;
    private final List<Tag> tags;

    private TagAttendeeRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.attendeeId = builder.attendeeId;
        this.tags = builder.tags;
    }

    public String meetingId() {
        return this.meetingId;
    }

    public String attendeeId() {
        return this.attendeeId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attendeeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagAttendeeRequest)) {
            return false;
        }
        TagAttendeeRequest other = (TagAttendeeRequest)((Object)obj);
        return Objects.equals(this.meetingId(), other.meetingId()) && Objects.equals(this.attendeeId(), other.attendeeId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"TagAttendeeRequest").add("MeetingId", (Object)this.meetingId()).add("AttendeeId", (Object)this.attendeeId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "AttendeeId": {
                return Optional.ofNullable(clazz.cast(this.attendeeId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagAttendeeRequest, T> g) {
        return obj -> g.apply((TagAttendeeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String meetingId;
        private String attendeeId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagAttendeeRequest model) {
            super(model);
            this.meetingId(model.meetingId);
            this.attendeeId(model.attendeeId);
            this.tags(model.tags);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        public final String getAttendeeId() {
            return this.attendeeId;
        }

        @Override
        public final Builder attendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
            return this;
        }

        public final void setAttendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = AttendeeTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = AttendeeTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TagAttendeeRequest build() {
            return new TagAttendeeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TagAttendeeRequest> {
        public Builder meetingId(String var1);

        public Builder attendeeId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

