/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.UserError;
import software.amazon.awssdk.services.chime.model.UserErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchSuspendUserResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, BatchSuspendUserResponse> {
    private static final SdkField<List<UserError>> USER_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserErrors").getter(BatchSuspendUserResponse.getter(BatchSuspendUserResponse::userErrors)).setter(BatchSuspendUserResponse.setter(Builder::userErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ERRORS_FIELD));
    private final List<UserError> userErrors;

    private BatchSuspendUserResponse(BuilderImpl builder) {
        super(builder);
        this.userErrors = builder.userErrors;
    }

    public boolean hasUserErrors() {
        return this.userErrors != null && !(this.userErrors instanceof SdkAutoConstructList);
    }

    public List<UserError> userErrors() {
        return this.userErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserErrors() ? this.userErrors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchSuspendUserResponse)) {
            return false;
        }
        BatchSuspendUserResponse other = (BatchSuspendUserResponse)((Object)obj);
        return this.hasUserErrors() == other.hasUserErrors() && Objects.equals(this.userErrors(), other.userErrors());
    }

    public String toString() {
        return ToString.builder((String)"BatchSuspendUserResponse").add("UserErrors", this.hasUserErrors() ? this.userErrors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserErrors": {
                return Optional.ofNullable(clazz.cast(this.userErrors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchSuspendUserResponse, T> g) {
        return obj -> g.apply((BatchSuspendUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<UserError> userErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchSuspendUserResponse model) {
            super(model);
            this.userErrors(model.userErrors);
        }

        public final Collection<UserError.Builder> getUserErrors() {
            if (this.userErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userErrors != null ? (Collection)this.userErrors.stream().map(UserError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userErrors(Collection<UserError> userErrors) {
            this.userErrors = UserErrorListCopier.copy(userErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userErrors(UserError ... userErrors) {
            this.userErrors(Arrays.asList(userErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userErrors(Consumer<UserError.Builder> ... userErrors) {
            this.userErrors(Stream.of(userErrors).map(c -> (UserError)((UserError.Builder)UserError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserErrors(Collection<UserError.BuilderImpl> userErrors) {
            this.userErrors = UserErrorListCopier.copyFromBuilder(userErrors);
        }

        @Override
        public BatchSuspendUserResponse build() {
            return new BatchSuspendUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchSuspendUserResponse> {
        public Builder userErrors(Collection<UserError> var1);

        public Builder userErrors(UserError ... var1);

        public Builder userErrors(Consumer<UserError.Builder> ... var1);
    }
}

