/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRoomMembershipRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, DeleteRoomMembershipRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRoomMembershipRequest.getter(DeleteRoomMembershipRequest::accountId)).setter(DeleteRoomMembershipRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<String> ROOM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRoomMembershipRequest.getter(DeleteRoomMembershipRequest::roomId)).setter(DeleteRoomMembershipRequest.setter(Builder::roomId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("roomId").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRoomMembershipRequest.getter(DeleteRoomMembershipRequest::memberId)).setter(DeleteRoomMembershipRequest.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memberId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ROOM_ID_FIELD, MEMBER_ID_FIELD));
    private final String accountId;
    private final String roomId;
    private final String memberId;

    private DeleteRoomMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.roomId = builder.roomId;
        this.memberId = builder.memberId;
    }

    public String accountId() {
        return this.accountId;
    }

    public String roomId() {
        return this.roomId;
    }

    public String memberId() {
        return this.memberId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRoomMembershipRequest)) {
            return false;
        }
        DeleteRoomMembershipRequest other = (DeleteRoomMembershipRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.roomId(), other.roomId()) && Objects.equals(this.memberId(), other.memberId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteRoomMembershipRequest").add("AccountId", (Object)this.accountId()).add("RoomId", (Object)this.roomId()).add("MemberId", (Object)this.memberId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "RoomId": {
                return Optional.ofNullable(clazz.cast(this.roomId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRoomMembershipRequest, T> g) {
        return obj -> g.apply((DeleteRoomMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String roomId;
        private String memberId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRoomMembershipRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.roomId(model.roomId);
            this.memberId(model.memberId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getRoomId() {
            return this.roomId;
        }

        @Override
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRoomMembershipRequest build() {
            return new DeleteRoomMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRoomMembershipRequest> {
        public Builder accountId(String var1);

        public Builder roomId(String var1);

        public Builder memberId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

