/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Participant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Participant> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Participant.getter(Participant::phoneNumber)).setter(Participant.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> PROXY_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Participant.getter(Participant::proxyPhoneNumber)).setter(Participant.setter(Builder::proxyPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyPhoneNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD, PROXY_PHONE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String phoneNumber;
    private final String proxyPhoneNumber;

    private Participant(BuilderImpl builder) {
        this.phoneNumber = builder.phoneNumber;
        this.proxyPhoneNumber = builder.proxyPhoneNumber;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public String proxyPhoneNumber() {
        return this.proxyPhoneNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyPhoneNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant other = (Participant)obj;
        return Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.proxyPhoneNumber(), other.proxyPhoneNumber());
    }

    public String toString() {
        return ToString.builder((String)"Participant").add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("ProxyPhoneNumber", (Object)(this.proxyPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "ProxyPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.proxyPhoneNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Participant, T> g) {
        return obj -> g.apply((Participant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneNumber;
        private String proxyPhoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Participant model) {
            this.phoneNumber(model.phoneNumber);
            this.proxyPhoneNumber(model.proxyPhoneNumber);
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getProxyPhoneNumber() {
            return this.proxyPhoneNumber;
        }

        @Override
        public final Builder proxyPhoneNumber(String proxyPhoneNumber) {
            this.proxyPhoneNumber = proxyPhoneNumber;
            return this;
        }

        public final void setProxyPhoneNumber(String proxyPhoneNumber) {
            this.proxyPhoneNumber = proxyPhoneNumber;
        }

        public Participant build() {
            return new Participant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Participant> {
        public Builder phoneNumber(String var1);

        public Builder proxyPhoneNumber(String var1);
    }
}

