/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.E164PhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, DisassociatePhoneNumbersFromVoiceConnectorGroupRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.getter(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest::voiceConnectorGroupId)).setter(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.setter(Builder::voiceConnectorGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorGroupId").build()}).build();
    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.getter(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest::e164PhoneNumbers)).setter(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.setter(Builder::e164PhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_GROUP_ID_FIELD, E164_PHONE_NUMBERS_FIELD));
    private final String voiceConnectorGroupId;
    private final List<String> e164PhoneNumbers;

    private DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorGroupId = builder.voiceConnectorGroupId;
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
    }

    public String voiceConnectorGroupId() {
        return this.voiceConnectorGroupId;
    }

    public boolean hasE164PhoneNumbers() {
        return this.e164PhoneNumbers != null && !(this.e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    public List<String> e164PhoneNumbers() {
        return this.e164PhoneNumbers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.e164PhoneNumbers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociatePhoneNumbersFromVoiceConnectorGroupRequest)) {
            return false;
        }
        DisassociatePhoneNumbersFromVoiceConnectorGroupRequest other = (DisassociatePhoneNumbersFromVoiceConnectorGroupRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorGroupId(), other.voiceConnectorGroupId()) && Objects.equals(this.e164PhoneNumbers(), other.e164PhoneNumbers());
    }

    public String toString() {
        return ToString.builder((String)"DisassociatePhoneNumbersFromVoiceConnectorGroupRequest").add("VoiceConnectorGroupId", (Object)this.voiceConnectorGroupId()).add("E164PhoneNumbers", (Object)(this.e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorGroupId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorGroupId()));
            }
            case "E164PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumbers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociatePhoneNumbersFromVoiceConnectorGroupRequest, T> g) {
        return obj -> g.apply((DisassociatePhoneNumbersFromVoiceConnectorGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorGroupId;
        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest model) {
            super(model);
            this.voiceConnectorGroupId(model.voiceConnectorGroupId);
            this.e164PhoneNumbers(model.e164PhoneNumbers);
        }

        public final String getVoiceConnectorGroupId() {
            return this.voiceConnectorGroupId;
        }

        @Override
        public final Builder voiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
            return this;
        }

        public final void setVoiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
        }

        public final Collection<String> getE164PhoneNumbers() {
            return this.e164PhoneNumbers;
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String ... e164PhoneNumbers) {
            this.e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociatePhoneNumbersFromVoiceConnectorGroupRequest build() {
            return new DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociatePhoneNumbersFromVoiceConnectorGroupRequest> {
        public Builder voiceConnectorGroupId(String var1);

        public Builder e164PhoneNumbers(Collection<String> var1);

        public Builder e164PhoneNumbers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

