/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.SensitiveStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVoiceConnectorTerminationCredentialsRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, DeleteVoiceConnectorTerminationCredentialsRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteVoiceConnectorTerminationCredentialsRequest.getter(DeleteVoiceConnectorTerminationCredentialsRequest::voiceConnectorId)).setter(DeleteVoiceConnectorTerminationCredentialsRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<List<String>> USERNAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeleteVoiceConnectorTerminationCredentialsRequest.getter(DeleteVoiceConnectorTerminationCredentialsRequest::usernames)).setter(DeleteVoiceConnectorTerminationCredentialsRequest.setter(Builder::usernames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usernames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, USERNAMES_FIELD));
    private final String voiceConnectorId;
    private final List<String> usernames;

    private DeleteVoiceConnectorTerminationCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.usernames = builder.usernames;
    }

    public String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public List<String> usernames() {
        return this.usernames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVoiceConnectorTerminationCredentialsRequest)) {
            return false;
        }
        DeleteVoiceConnectorTerminationCredentialsRequest other = (DeleteVoiceConnectorTerminationCredentialsRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.usernames(), other.usernames());
    }

    public String toString() {
        return ToString.builder((String)"DeleteVoiceConnectorTerminationCredentialsRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("Usernames", (Object)(this.usernames() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "Usernames": {
                return Optional.ofNullable(clazz.cast(this.usernames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVoiceConnectorTerminationCredentialsRequest, T> g) {
        return obj -> g.apply((DeleteVoiceConnectorTerminationCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private List<String> usernames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVoiceConnectorTerminationCredentialsRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.usernames(model.usernames);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final Collection<String> getUsernames() {
            return this.usernames;
        }

        @Override
        public final Builder usernames(Collection<String> usernames) {
            this.usernames = SensitiveStringListCopier.copy(usernames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernames(String ... usernames) {
            this.usernames(Arrays.asList(usernames));
            return this;
        }

        public final void setUsernames(Collection<String> usernames) {
            this.usernames = SensitiveStringListCopier.copy(usernames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVoiceConnectorTerminationCredentialsRequest build() {
            return new DeleteVoiceConnectorTerminationCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteVoiceConnectorTerminationCredentialsRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder usernames(Collection<String> var1);

        public Builder usernames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

