/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;

@SdkInternalApi
public abstract class BaseCrcChecksum
implements SdkChecksum {
    private Checksum checksum;
    private Checksum lastMarkedChecksum;

    public BaseCrcChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    @Override
    public void mark(int readLimit) {
        this.lastMarkedChecksum = this.cloneChecksum(this.checksum);
    }

    @Override
    public void update(int b) {
        this.checksum.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checksum.update(b, off, len);
    }

    @Override
    public long getValue() {
        return this.checksum.getValue();
    }

    @Override
    public void reset() {
        if (this.lastMarkedChecksum == null) {
            this.checksum.reset();
        } else {
            this.checksum = this.cloneChecksum(this.lastMarkedChecksum);
        }
    }

    abstract Checksum cloneChecksum(Checksum var1);
}

