/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifes a user level permission for a channel configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlackUserIdentity implements SdkPojo, Serializable,
        ToCopyableBuilder<SlackUserIdentity.Builder, SlackUserIdentity> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(SlackUserIdentity::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatConfigurationArn").getter(getter(SlackUserIdentity::chatConfigurationArn))
            .setter(setter(Builder::chatConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build())
            .build();

    private static final SdkField<String> SLACK_TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackTeamId").getter(getter(SlackUserIdentity::slackTeamId)).setter(setter(Builder::slackTeamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackTeamId").build()).build();

    private static final SdkField<String> SLACK_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackUserId").getter(getter(SlackUserIdentity::slackUserId)).setter(setter(Builder::slackUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackUserId").build()).build();

    private static final SdkField<String> AWS_USER_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsUserIdentity").getter(getter(SlackUserIdentity::awsUserIdentity))
            .setter(setter(Builder::awsUserIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsUserIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            CHAT_CONFIGURATION_ARN_FIELD, SLACK_TEAM_ID_FIELD, SLACK_USER_ID_FIELD, AWS_USER_IDENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String iamRoleArn;

    private final String chatConfigurationArn;

    private final String slackTeamId;

    private final String slackUserId;

    private final String awsUserIdentity;

    private SlackUserIdentity(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.slackTeamId = builder.slackTeamId;
        this.slackUserId = builder.slackUserId;
        this.awsUserIdentity = builder.awsUserIdentity;
    }

    /**
     * <p>
     * A user-defined role that AWS Chatbot assumes. This is not the service-linked role.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS
     * Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
     * </p>
     * 
     * @return A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for
     *         AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SlackChannelConfiguration associated with the user identity to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SlackChannelConfiguration associated with the user identity to
     *         delete.
     */
    public final String chatConfigurationArn() {
        return chatConfigurationArn;
    }

    /**
     * <p>
     * The ID of the Slack workspace authorized with AWS Chatbot.
     * </p>
     * 
     * @return The ID of the Slack workspace authorized with AWS Chatbot.
     */
    public final String slackTeamId() {
        return slackTeamId;
    }

    /**
     * <p>
     * The ID of the user in Slack
     * </p>
     * 
     * @return The ID of the user in Slack
     */
    public final String slackUserId() {
        return slackUserId;
    }

    /**
     * <p>
     * The AWS user identity ARN used to associate a Slack user ID with an IAM Role.
     * </p>
     * 
     * @return The AWS user identity ARN used to associate a Slack user ID with an IAM Role.
     */
    public final String awsUserIdentity() {
        return awsUserIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(slackTeamId());
        hashCode = 31 * hashCode + Objects.hashCode(slackUserId());
        hashCode = 31 * hashCode + Objects.hashCode(awsUserIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackUserIdentity)) {
            return false;
        }
        SlackUserIdentity other = (SlackUserIdentity) obj;
        return Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(chatConfigurationArn(), other.chatConfigurationArn())
                && Objects.equals(slackTeamId(), other.slackTeamId()) && Objects.equals(slackUserId(), other.slackUserId())
                && Objects.equals(awsUserIdentity(), other.awsUserIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlackUserIdentity").add("IamRoleArn", iamRoleArn())
                .add("ChatConfigurationArn", chatConfigurationArn()).add("SlackTeamId", slackTeamId())
                .add("SlackUserId", slackUserId()).add("AwsUserIdentity", awsUserIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ChatConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatConfigurationArn()));
        case "SlackTeamId":
            return Optional.ofNullable(clazz.cast(slackTeamId()));
        case "SlackUserId":
            return Optional.ofNullable(clazz.cast(slackUserId()));
        case "AwsUserIdentity":
            return Optional.ofNullable(clazz.cast(awsUserIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("ChatConfigurationArn", CHAT_CONFIGURATION_ARN_FIELD);
        map.put("SlackTeamId", SLACK_TEAM_ID_FIELD);
        map.put("SlackUserId", SLACK_USER_ID_FIELD);
        map.put("AwsUserIdentity", AWS_USER_IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlackUserIdentity, T> g) {
        return obj -> g.apply((SlackUserIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlackUserIdentity> {
        /**
         * <p>
         * A user-defined role that AWS Chatbot assumes. This is not the service-linked role.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS
         * Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * </p>
         * 
         * @param iamRoleArn
         *        A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies
         *        for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SlackChannelConfiguration associated with the user identity to delete.
         * </p>
         * 
         * @param chatConfigurationArn
         *        The Amazon Resource Name (ARN) of the SlackChannelConfiguration associated with the user identity to
         *        delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatConfigurationArn(String chatConfigurationArn);

        /**
         * <p>
         * The ID of the Slack workspace authorized with AWS Chatbot.
         * </p>
         * 
         * @param slackTeamId
         *        The ID of the Slack workspace authorized with AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackTeamId(String slackTeamId);

        /**
         * <p>
         * The ID of the user in Slack
         * </p>
         * 
         * @param slackUserId
         *        The ID of the user in Slack
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackUserId(String slackUserId);

        /**
         * <p>
         * The AWS user identity ARN used to associate a Slack user ID with an IAM Role.
         * </p>
         * 
         * @param awsUserIdentity
         *        The AWS user identity ARN used to associate a Slack user ID with an IAM Role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsUserIdentity(String awsUserIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleArn;

        private String chatConfigurationArn;

        private String slackTeamId;

        private String slackUserId;

        private String awsUserIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(SlackUserIdentity model) {
            iamRoleArn(model.iamRoleArn);
            chatConfigurationArn(model.chatConfigurationArn);
            slackTeamId(model.slackTeamId);
            slackUserId(model.slackUserId);
            awsUserIdentity(model.awsUserIdentity);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getChatConfigurationArn() {
            return chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getSlackTeamId() {
            return slackTeamId;
        }

        public final void setSlackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
        }

        @Override
        public final Builder slackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
            return this;
        }

        public final String getSlackUserId() {
            return slackUserId;
        }

        public final void setSlackUserId(String slackUserId) {
            this.slackUserId = slackUserId;
        }

        @Override
        public final Builder slackUserId(String slackUserId) {
            this.slackUserId = slackUserId;
            return this;
        }

        public final String getAwsUserIdentity() {
            return awsUserIdentity;
        }

        public final void setAwsUserIdentity(String awsUserIdentity) {
            this.awsUserIdentity = awsUserIdentity;
        }

        @Override
        public final Builder awsUserIdentity(String awsUserIdentity) {
            this.awsUserIdentity = awsUserIdentity;
            return this;
        }

        @Override
        public SlackUserIdentity build() {
            return new SlackUserIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
