/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChimeWebhookConfigurationsResponse extends ChatbotResponse implements
        ToCopyableBuilder<DescribeChimeWebhookConfigurationsResponse.Builder, DescribeChimeWebhookConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeChimeWebhookConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ChimeWebhookConfiguration>> WEBHOOK_CONFIGURATIONS_FIELD = SdkField
            .<List<ChimeWebhookConfiguration>> builder(MarshallingType.LIST)
            .memberName("WebhookConfigurations")
            .getter(getter(DescribeChimeWebhookConfigurationsResponse::webhookConfigurations))
            .setter(setter(Builder::webhookConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChimeWebhookConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChimeWebhookConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WEBHOOK_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ChimeWebhookConfiguration> webhookConfigurations;

    private DescribeChimeWebhookConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.webhookConfigurations = builder.webhookConfigurations;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WebhookConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWebhookConfigurations() {
        return webhookConfigurations != null && !(webhookConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Chime webhooks associated with the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWebhookConfigurations} method.
     * </p>
     * 
     * @return A list of Amazon Chime webhooks associated with the account.
     */
    public final List<ChimeWebhookConfiguration> webhookConfigurations() {
        return webhookConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWebhookConfigurations() ? webhookConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChimeWebhookConfigurationsResponse)) {
            return false;
        }
        DescribeChimeWebhookConfigurationsResponse other = (DescribeChimeWebhookConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWebhookConfigurations() == other.hasWebhookConfigurations()
                && Objects.equals(webhookConfigurations(), other.webhookConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChimeWebhookConfigurationsResponse").add("NextToken", nextToken())
                .add("WebhookConfigurations", hasWebhookConfigurations() ? webhookConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WebhookConfigurations":
            return Optional.ofNullable(clazz.cast(webhookConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WebhookConfigurations", WEBHOOK_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeChimeWebhookConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeChimeWebhookConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChatbotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChimeWebhookConfigurationsResponse> {
        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of Amazon Chime webhooks associated with the account.
         * </p>
         * 
         * @param webhookConfigurations
         *        A list of Amazon Chime webhooks associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookConfigurations(Collection<ChimeWebhookConfiguration> webhookConfigurations);

        /**
         * <p>
         * A list of Amazon Chime webhooks associated with the account.
         * </p>
         * 
         * @param webhookConfigurations
         *        A list of Amazon Chime webhooks associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookConfigurations(ChimeWebhookConfiguration... webhookConfigurations);

        /**
         * <p>
         * A list of Amazon Chime webhooks associated with the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #webhookConfigurations(List<ChimeWebhookConfiguration>)}.
         * 
         * @param webhookConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webhookConfigurations(java.util.Collection<ChimeWebhookConfiguration>)
         */
        Builder webhookConfigurations(Consumer<ChimeWebhookConfiguration.Builder>... webhookConfigurations);
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ChimeWebhookConfiguration> webhookConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChimeWebhookConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            webhookConfigurations(model.webhookConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChimeWebhookConfiguration.Builder> getWebhookConfigurations() {
            List<ChimeWebhookConfiguration.Builder> result = ChimeWebhookConfigurationListCopier
                    .copyToBuilder(this.webhookConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebhookConfigurations(Collection<ChimeWebhookConfiguration.BuilderImpl> webhookConfigurations) {
            this.webhookConfigurations = ChimeWebhookConfigurationListCopier.copyFromBuilder(webhookConfigurations);
        }

        @Override
        public final Builder webhookConfigurations(Collection<ChimeWebhookConfiguration> webhookConfigurations) {
            this.webhookConfigurations = ChimeWebhookConfigurationListCopier.copy(webhookConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhookConfigurations(ChimeWebhookConfiguration... webhookConfigurations) {
            webhookConfigurations(Arrays.asList(webhookConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhookConfigurations(Consumer<ChimeWebhookConfiguration.Builder>... webhookConfigurations) {
            webhookConfigurations(Stream.of(webhookConfigurations)
                    .map(c -> ChimeWebhookConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeChimeWebhookConfigurationsResponse build() {
            return new DescribeChimeWebhookConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
