/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A criteria for when a button should be shown based on values in the notification
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomActionAttachmentCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomActionAttachmentCriteria.Builder, CustomActionAttachmentCriteria> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(CustomActionAttachmentCriteria::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<String> VARIABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariableName").getter(getter(CustomActionAttachmentCriteria::variableName))
            .setter(setter(Builder::variableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariableName").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(CustomActionAttachmentCriteria::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD,
            VARIABLE_NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operator;

    private final String variableName;

    private final String value;

    private CustomActionAttachmentCriteria(BuilderImpl builder) {
        this.operator = builder.operator;
        this.variableName = builder.variableName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The operation to perform on the named variable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link CustomActionAttachmentCriteriaOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operation to perform on the named variable.
     * @see CustomActionAttachmentCriteriaOperator
     */
    public final CustomActionAttachmentCriteriaOperator operator() {
        return CustomActionAttachmentCriteriaOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operation to perform on the named variable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link CustomActionAttachmentCriteriaOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operation to perform on the named variable.
     * @see CustomActionAttachmentCriteriaOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The name of the variable to operate on.
     * </p>
     * 
     * @return The name of the variable to operate on.
     */
    public final String variableName() {
        return variableName;
    }

    /**
     * <p>
     * A value that is compared with the actual value of the variable based on the behavior of the operator.
     * </p>
     * 
     * @return A value that is compared with the actual value of the variable based on the behavior of the operator.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(variableName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionAttachmentCriteria)) {
            return false;
        }
        CustomActionAttachmentCriteria other = (CustomActionAttachmentCriteria) obj;
        return Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(variableName(), other.variableName()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomActionAttachmentCriteria").add("Operator", operatorAsString())
                .add("VariableName", variableName()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "VariableName":
            return Optional.ofNullable(clazz.cast(variableName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("VariableName", VARIABLE_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionAttachmentCriteria, T> g) {
        return obj -> g.apply((CustomActionAttachmentCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomActionAttachmentCriteria> {
        /**
         * <p>
         * The operation to perform on the named variable.
         * </p>
         * 
         * @param operator
         *        The operation to perform on the named variable.
         * @see CustomActionAttachmentCriteriaOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomActionAttachmentCriteriaOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operation to perform on the named variable.
         * </p>
         * 
         * @param operator
         *        The operation to perform on the named variable.
         * @see CustomActionAttachmentCriteriaOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomActionAttachmentCriteriaOperator
         */
        Builder operator(CustomActionAttachmentCriteriaOperator operator);

        /**
         * <p>
         * The name of the variable to operate on.
         * </p>
         * 
         * @param variableName
         *        The name of the variable to operate on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableName(String variableName);

        /**
         * <p>
         * A value that is compared with the actual value of the variable based on the behavior of the operator.
         * </p>
         * 
         * @param value
         *        A value that is compared with the actual value of the variable based on the behavior of the operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String operator;

        private String variableName;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionAttachmentCriteria model) {
            operator(model.operator);
            variableName(model.variableName);
            value(model.value);
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(CustomActionAttachmentCriteriaOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getVariableName() {
            return variableName;
        }

        public final void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        @Override
        public final Builder variableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public CustomActionAttachmentCriteria build() {
            return new CustomActionAttachmentCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
