/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.SnsTopicArnListCopier;
import software.amazon.awssdk.services.chatbot.model.Tag;
import software.amazon.awssdk.services.chatbot.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChimeWebhookConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChimeWebhookConfiguration> {
    private static final SdkField<String> WEBHOOK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebhookDescription").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::webhookDescription)).setter(ChimeWebhookConfiguration.setter(Builder::webhookDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookDescription").build()}).build();
    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChatConfigurationArn").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::chatConfigurationArn)).setter(ChimeWebhookConfiguration.setter(Builder::chatConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::iamRoleArn)).setter(ChimeWebhookConfiguration.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnsTopicArns").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::snsTopicArns)).setter(ChimeWebhookConfiguration.setter(Builder::snsTopicArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::configurationName)).setter(ChimeWebhookConfiguration.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingLevel").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::loggingLevel)).setter(ChimeWebhookConfiguration.setter(Builder::loggingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::tags)).setter(ChimeWebhookConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::state)).setter(ChimeWebhookConfiguration.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(ChimeWebhookConfiguration.getter(ChimeWebhookConfiguration::stateReason)).setter(ChimeWebhookConfiguration.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOK_DESCRIPTION_FIELD, CHAT_CONFIGURATION_ARN_FIELD, IAM_ROLE_ARN_FIELD, SNS_TOPIC_ARNS_FIELD, CONFIGURATION_NAME_FIELD, LOGGING_LEVEL_FIELD, TAGS_FIELD, STATE_FIELD, STATE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChimeWebhookConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String webhookDescription;
    private final String chatConfigurationArn;
    private final String iamRoleArn;
    private final List<String> snsTopicArns;
    private final String configurationName;
    private final String loggingLevel;
    private final List<Tag> tags;
    private final String state;
    private final String stateReason;

    private ChimeWebhookConfiguration(BuilderImpl builder) {
        this.webhookDescription = builder.webhookDescription;
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.snsTopicArns = builder.snsTopicArns;
        this.configurationName = builder.configurationName;
        this.loggingLevel = builder.loggingLevel;
        this.tags = builder.tags;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    public final String webhookDescription() {
        return this.webhookDescription;
    }

    public final String chatConfigurationArn() {
        return this.chatConfigurationArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasSnsTopicArns() {
        return this.snsTopicArns != null && !(this.snsTopicArns instanceof SdkAutoConstructList);
    }

    public final List<String> snsTopicArns() {
        return this.snsTopicArns;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final String loggingLevel() {
        return this.loggingLevel;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String state() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webhookDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnsTopicArns() ? this.snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChimeWebhookConfiguration)) {
            return false;
        }
        ChimeWebhookConfiguration other = (ChimeWebhookConfiguration)obj;
        return Objects.equals(this.webhookDescription(), other.webhookDescription()) && Objects.equals(this.chatConfigurationArn(), other.chatConfigurationArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasSnsTopicArns() == other.hasSnsTopicArns() && Objects.equals(this.snsTopicArns(), other.snsTopicArns()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.loggingLevel(), other.loggingLevel()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateReason(), other.stateReason());
    }

    public final String toString() {
        return ToString.builder((String)"ChimeWebhookConfiguration").add("WebhookDescription", (Object)(this.webhookDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("ChatConfigurationArn", (Object)this.chatConfigurationArn()).add("IamRoleArn", (Object)this.iamRoleArn()).add("SnsTopicArns", this.hasSnsTopicArns() ? this.snsTopicArns() : null).add("ConfigurationName", (Object)this.configurationName()).add("LoggingLevel", (Object)this.loggingLevel()).add("Tags", this.hasTags() ? this.tags() : null).add("State", (Object)this.state()).add("StateReason", (Object)this.stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebhookDescription": {
                return Optional.ofNullable(clazz.cast(this.webhookDescription()));
            }
            case "ChatConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.chatConfigurationArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "SnsTopicArns": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArns()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "LoggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevel()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WebhookDescription", WEBHOOK_DESCRIPTION_FIELD);
        map.put("ChatConfigurationArn", CHAT_CONFIGURATION_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("SnsTopicArns", SNS_TOPIC_ARNS_FIELD);
        map.put("ConfigurationName", CONFIGURATION_NAME_FIELD);
        map.put("LoggingLevel", LOGGING_LEVEL_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChimeWebhookConfiguration, T> g) {
        return obj -> g.apply((ChimeWebhookConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String webhookDescription;
        private String chatConfigurationArn;
        private String iamRoleArn;
        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();
        private String configurationName;
        private String loggingLevel;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ChimeWebhookConfiguration model) {
            this.webhookDescription(model.webhookDescription);
            this.chatConfigurationArn(model.chatConfigurationArn);
            this.iamRoleArn(model.iamRoleArn);
            this.snsTopicArns(model.snsTopicArns);
            this.configurationName(model.configurationName);
            this.loggingLevel(model.loggingLevel);
            this.tags(model.tags);
            this.state(model.state);
            this.stateReason(model.stateReason);
        }

        public final String getWebhookDescription() {
            return this.webhookDescription;
        }

        public final void setWebhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
        }

        @Override
        public final Builder webhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
            return this;
        }

        public final String getChatConfigurationArn() {
            return this.chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (this.snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String ... snsTopicArns) {
            this.snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public ChimeWebhookConfiguration build() {
            return new ChimeWebhookConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChimeWebhookConfiguration> {
        public Builder webhookDescription(String var1);

        public Builder chatConfigurationArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder snsTopicArns(Collection<String> var1);

        public Builder snsTopicArns(String ... var1);

        public Builder configurationName(String var1);

        public Builder loggingLevel(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder state(String var1);

        public Builder stateReason(String var1);
    }
}

