/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotResponse;
import software.amazon.awssdk.services.chatbot.model.SlackWorkspace;
import software.amazon.awssdk.services.chatbot.model.SlackWorkspacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSlackWorkspacesResponse
extends ChatbotResponse
implements ToCopyableBuilder<Builder, DescribeSlackWorkspacesResponse> {
    private static final SdkField<List<SlackWorkspace>> SLACK_WORKSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SlackWorkspaces").getter(DescribeSlackWorkspacesResponse.getter(DescribeSlackWorkspacesResponse::slackWorkspaces)).setter(DescribeSlackWorkspacesResponse.setter(Builder::slackWorkspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackWorkspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlackWorkspace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSlackWorkspacesResponse.getter(DescribeSlackWorkspacesResponse::nextToken)).setter(DescribeSlackWorkspacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLACK_WORKSPACES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SlackWorkspace> slackWorkspaces;
    private final String nextToken;

    private DescribeSlackWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.slackWorkspaces = builder.slackWorkspaces;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSlackWorkspaces() {
        return this.slackWorkspaces != null && !(this.slackWorkspaces instanceof SdkAutoConstructList);
    }

    public final List<SlackWorkspace> slackWorkspaces() {
        return this.slackWorkspaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlackWorkspaces() ? this.slackWorkspaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSlackWorkspacesResponse)) {
            return false;
        }
        DescribeSlackWorkspacesResponse other = (DescribeSlackWorkspacesResponse)((Object)obj);
        return this.hasSlackWorkspaces() == other.hasSlackWorkspaces() && Objects.equals(this.slackWorkspaces(), other.slackWorkspaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSlackWorkspacesResponse").add("SlackWorkspaces", this.hasSlackWorkspaces() ? this.slackWorkspaces() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SlackWorkspaces": {
                return Optional.ofNullable(clazz.cast(this.slackWorkspaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSlackWorkspacesResponse, T> g) {
        return obj -> g.apply((DescribeSlackWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotResponse.BuilderImpl
    implements Builder {
        private List<SlackWorkspace> slackWorkspaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSlackWorkspacesResponse model) {
            super(model);
            this.slackWorkspaces(model.slackWorkspaces);
            this.nextToken(model.nextToken);
        }

        public final List<SlackWorkspace.Builder> getSlackWorkspaces() {
            List<SlackWorkspace.Builder> result = SlackWorkspacesListCopier.copyToBuilder(this.slackWorkspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlackWorkspaces(Collection<SlackWorkspace.BuilderImpl> slackWorkspaces) {
            this.slackWorkspaces = SlackWorkspacesListCopier.copyFromBuilder(slackWorkspaces);
        }

        @Override
        public final Builder slackWorkspaces(Collection<SlackWorkspace> slackWorkspaces) {
            this.slackWorkspaces = SlackWorkspacesListCopier.copy(slackWorkspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaces(SlackWorkspace ... slackWorkspaces) {
            this.slackWorkspaces(Arrays.asList(slackWorkspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaces(Consumer<SlackWorkspace.Builder> ... slackWorkspaces) {
            this.slackWorkspaces(Stream.of(slackWorkspaces).map(c -> (SlackWorkspace)((SlackWorkspace.Builder)SlackWorkspace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSlackWorkspacesResponse build() {
            return new DescribeSlackWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChatbotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSlackWorkspacesResponse> {
        public Builder slackWorkspaces(Collection<SlackWorkspace> var1);

        public Builder slackWorkspaces(SlackWorkspace ... var1);

        public Builder slackWorkspaces(Consumer<SlackWorkspace.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

