/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotRequest;
import software.amazon.awssdk.services.chatbot.model.GuardrailPolicyArnListCopier;
import software.amazon.awssdk.services.chatbot.model.SnsTopicArnListCopier;
import software.amazon.awssdk.services.chatbot.model.Tag;
import software.amazon.awssdk.services.chatbot.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSlackChannelConfigurationRequest
extends ChatbotRequest
implements ToCopyableBuilder<Builder, CreateSlackChannelConfigurationRequest> {
    private static final SdkField<String> SLACK_TEAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlackTeamId").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::slackTeamId)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::slackTeamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackTeamId").build()}).build();
    private static final SdkField<String> SLACK_CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlackChannelId").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::slackChannelId)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::slackChannelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackChannelId").build()}).build();
    private static final SdkField<String> SLACK_CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlackChannelName").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::slackChannelName)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::slackChannelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackChannelName").build()}).build();
    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnsTopicArns").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::snsTopicArns)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::snsTopicArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::iamRoleArn)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::configurationName)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingLevel").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::loggingLevel)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::loggingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()}).build();
    private static final SdkField<List<String>> GUARDRAIL_POLICY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GuardrailPolicyArns").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::guardrailPolicyArns)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::guardrailPolicyArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardrailPolicyArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USER_AUTHORIZATION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserAuthorizationRequired").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::userAuthorizationRequired)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::userAuthorizationRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAuthorizationRequired").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateSlackChannelConfigurationRequest.getter(CreateSlackChannelConfigurationRequest::tags)).setter(CreateSlackChannelConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLACK_TEAM_ID_FIELD, SLACK_CHANNEL_ID_FIELD, SLACK_CHANNEL_NAME_FIELD, SNS_TOPIC_ARNS_FIELD, IAM_ROLE_ARN_FIELD, CONFIGURATION_NAME_FIELD, LOGGING_LEVEL_FIELD, GUARDRAIL_POLICY_ARNS_FIELD, USER_AUTHORIZATION_REQUIRED_FIELD, TAGS_FIELD));
    private final String slackTeamId;
    private final String slackChannelId;
    private final String slackChannelName;
    private final List<String> snsTopicArns;
    private final String iamRoleArn;
    private final String configurationName;
    private final String loggingLevel;
    private final List<String> guardrailPolicyArns;
    private final Boolean userAuthorizationRequired;
    private final List<Tag> tags;

    private CreateSlackChannelConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.slackTeamId = builder.slackTeamId;
        this.slackChannelId = builder.slackChannelId;
        this.slackChannelName = builder.slackChannelName;
        this.snsTopicArns = builder.snsTopicArns;
        this.iamRoleArn = builder.iamRoleArn;
        this.configurationName = builder.configurationName;
        this.loggingLevel = builder.loggingLevel;
        this.guardrailPolicyArns = builder.guardrailPolicyArns;
        this.userAuthorizationRequired = builder.userAuthorizationRequired;
        this.tags = builder.tags;
    }

    public final String slackTeamId() {
        return this.slackTeamId;
    }

    public final String slackChannelId() {
        return this.slackChannelId;
    }

    public final String slackChannelName() {
        return this.slackChannelName;
    }

    public final boolean hasSnsTopicArns() {
        return this.snsTopicArns != null && !(this.snsTopicArns instanceof SdkAutoConstructList);
    }

    public final List<String> snsTopicArns() {
        return this.snsTopicArns;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final String loggingLevel() {
        return this.loggingLevel;
    }

    public final boolean hasGuardrailPolicyArns() {
        return this.guardrailPolicyArns != null && !(this.guardrailPolicyArns instanceof SdkAutoConstructList);
    }

    public final List<String> guardrailPolicyArns() {
        return this.guardrailPolicyArns;
    }

    public final Boolean userAuthorizationRequired() {
        return this.userAuthorizationRequired;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.slackTeamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slackChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slackChannelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnsTopicArns() ? this.snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userAuthorizationRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSlackChannelConfigurationRequest)) {
            return false;
        }
        CreateSlackChannelConfigurationRequest other = (CreateSlackChannelConfigurationRequest)((Object)obj);
        return Objects.equals(this.slackTeamId(), other.slackTeamId()) && Objects.equals(this.slackChannelId(), other.slackChannelId()) && Objects.equals(this.slackChannelName(), other.slackChannelName()) && this.hasSnsTopicArns() == other.hasSnsTopicArns() && Objects.equals(this.snsTopicArns(), other.snsTopicArns()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.loggingLevel(), other.loggingLevel()) && this.hasGuardrailPolicyArns() == other.hasGuardrailPolicyArns() && Objects.equals(this.guardrailPolicyArns(), other.guardrailPolicyArns()) && Objects.equals(this.userAuthorizationRequired(), other.userAuthorizationRequired()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSlackChannelConfigurationRequest").add("SlackTeamId", (Object)this.slackTeamId()).add("SlackChannelId", (Object)this.slackChannelId()).add("SlackChannelName", (Object)this.slackChannelName()).add("SnsTopicArns", this.hasSnsTopicArns() ? this.snsTopicArns() : null).add("IamRoleArn", (Object)this.iamRoleArn()).add("ConfigurationName", (Object)this.configurationName()).add("LoggingLevel", (Object)this.loggingLevel()).add("GuardrailPolicyArns", this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null).add("UserAuthorizationRequired", (Object)this.userAuthorizationRequired()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SlackTeamId": {
                return Optional.ofNullable(clazz.cast(this.slackTeamId()));
            }
            case "SlackChannelId": {
                return Optional.ofNullable(clazz.cast(this.slackChannelId()));
            }
            case "SlackChannelName": {
                return Optional.ofNullable(clazz.cast(this.slackChannelName()));
            }
            case "SnsTopicArns": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArns()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "LoggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevel()));
            }
            case "GuardrailPolicyArns": {
                return Optional.ofNullable(clazz.cast(this.guardrailPolicyArns()));
            }
            case "UserAuthorizationRequired": {
                return Optional.ofNullable(clazz.cast(this.userAuthorizationRequired()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSlackChannelConfigurationRequest, T> g) {
        return obj -> g.apply((CreateSlackChannelConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotRequest.BuilderImpl
    implements Builder {
        private String slackTeamId;
        private String slackChannelId;
        private String slackChannelName;
        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();
        private String iamRoleArn;
        private String configurationName;
        private String loggingLevel;
        private List<String> guardrailPolicyArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean userAuthorizationRequired;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSlackChannelConfigurationRequest model) {
            super(model);
            this.slackTeamId(model.slackTeamId);
            this.slackChannelId(model.slackChannelId);
            this.slackChannelName(model.slackChannelName);
            this.snsTopicArns(model.snsTopicArns);
            this.iamRoleArn(model.iamRoleArn);
            this.configurationName(model.configurationName);
            this.loggingLevel(model.loggingLevel);
            this.guardrailPolicyArns(model.guardrailPolicyArns);
            this.userAuthorizationRequired(model.userAuthorizationRequired);
            this.tags(model.tags);
        }

        public final String getSlackTeamId() {
            return this.slackTeamId;
        }

        public final void setSlackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
        }

        @Override
        public final Builder slackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
            return this;
        }

        public final String getSlackChannelId() {
            return this.slackChannelId;
        }

        public final void setSlackChannelId(String slackChannelId) {
            this.slackChannelId = slackChannelId;
        }

        @Override
        public final Builder slackChannelId(String slackChannelId) {
            this.slackChannelId = slackChannelId;
            return this;
        }

        public final String getSlackChannelName() {
            return this.slackChannelName;
        }

        public final void setSlackChannelName(String slackChannelName) {
            this.slackChannelName = slackChannelName;
        }

        @Override
        public final Builder slackChannelName(String slackChannelName) {
            this.slackChannelName = slackChannelName;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (this.snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String ... snsTopicArns) {
            this.snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final Collection<String> getGuardrailPolicyArns() {
            if (this.guardrailPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.guardrailPolicyArns;
        }

        public final void setGuardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
        }

        @Override
        public final Builder guardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailPolicyArns(String ... guardrailPolicyArns) {
            this.guardrailPolicyArns(Arrays.asList(guardrailPolicyArns));
            return this;
        }

        public final Boolean getUserAuthorizationRequired() {
            return this.userAuthorizationRequired;
        }

        public final void setUserAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
        }

        @Override
        public final Builder userAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSlackChannelConfigurationRequest build() {
            return new CreateSlackChannelConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChatbotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSlackChannelConfigurationRequest> {
        public Builder slackTeamId(String var1);

        public Builder slackChannelId(String var1);

        public Builder slackChannelName(String var1);

        public Builder snsTopicArns(Collection<String> var1);

        public Builder snsTopicArns(String ... var1);

        public Builder iamRoleArn(String var1);

        public Builder configurationName(String var1);

        public Builder loggingLevel(String var1);

        public Builder guardrailPolicyArns(Collection<String> var1);

        public Builder guardrailPolicyArns(String ... var1);

        public Builder userAuthorizationRequired(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

