/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredTeam
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredTeam> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(ConfiguredTeam.getter(ConfiguredTeam::tenantId)).setter(ConfiguredTeam.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()}).build();
    private static final SdkField<String> TEAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeamId").getter(ConfiguredTeam.getter(ConfiguredTeam::teamId)).setter(ConfiguredTeam.setter(Builder::teamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()}).build();
    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeamName").getter(ConfiguredTeam.getter(ConfiguredTeam::teamName)).setter(ConfiguredTeam.setter(Builder::teamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD, TEAM_ID_FIELD, TEAM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tenantId;
    private final String teamId;
    private final String teamName;

    private ConfiguredTeam(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String teamId() {
        return this.teamId;
    }

    public final String teamName() {
        return this.teamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.teamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.teamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTeam)) {
            return false;
        }
        ConfiguredTeam other = (ConfiguredTeam)obj;
        return Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.teamId(), other.teamId()) && Objects.equals(this.teamName(), other.teamName());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredTeam").add("TenantId", (Object)this.tenantId()).add("TeamId", (Object)this.teamId()).add("TeamName", (Object)this.teamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "TeamId": {
                return Optional.ofNullable(clazz.cast(this.teamId()));
            }
            case "TeamName": {
                return Optional.ofNullable(clazz.cast(this.teamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTeam, T> g) {
        return obj -> g.apply((ConfiguredTeam)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantId;
        private String teamId;
        private String teamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTeam model) {
            this.tenantId(model.tenantId);
            this.teamId(model.teamId);
            this.teamName(model.teamName);
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTeamId() {
            return this.teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return this.teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        public ConfiguredTeam build() {
            return new ConfiguredTeam(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredTeam> {
        public Builder tenantId(String var1);

        public Builder teamId(String var1);

        public Builder teamName(String var1);
    }
}

