/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFragmentsResponse extends KinesisVideoArchivedMediaResponse implements
        ToCopyableBuilder<ListFragmentsResponse.Builder, ListFragmentsResponse> {
    private static final SdkField<List<Fragment>> FRAGMENTS_FIELD = SdkField
            .<List<Fragment>> builder(MarshallingType.LIST)
            .memberName("Fragments")
            .getter(getter(ListFragmentsResponse::fragments))
            .setter(setter(Builder::fragments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fragments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Fragment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Fragment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFragmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Fragment> fragments;

    private final String nextToken;

    private ListFragmentsResponse(BuilderImpl builder) {
        super(builder);
        this.fragments = builder.fragments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fragments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFragments() {
        return fragments != null && !(fragments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of archived <a>Fragment</a> objects from the stream that meet the selector criteria. Results are in no
     * specific order, even across pages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFragments} method.
     * </p>
     * 
     * @return A list of archived <a>Fragment</a> objects from the stream that meet the selector criteria. Results are
     *         in no specific order, even across pages.
     */
    public final List<Fragment> fragments() {
        return fragments;
    }

    /**
     * <p>
     * If the returned list is truncated, the operation returns this token to use to retrieve the next page of results.
     * This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return If the returned list is truncated, the operation returns this token to use to retrieve the next page of
     *         results. This value is <code>null</code> when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFragments() ? fragments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFragmentsResponse)) {
            return false;
        }
        ListFragmentsResponse other = (ListFragmentsResponse) obj;
        return hasFragments() == other.hasFragments() && Objects.equals(fragments(), other.fragments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFragmentsResponse").add("Fragments", hasFragments() ? fragments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fragments":
            return Optional.ofNullable(clazz.cast(fragments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFragmentsResponse, T> g) {
        return obj -> g.apply((ListFragmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoArchivedMediaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFragmentsResponse> {
        /**
         * <p>
         * A list of archived <a>Fragment</a> objects from the stream that meet the selector criteria. Results are in no
         * specific order, even across pages.
         * </p>
         * 
         * @param fragments
         *        A list of archived <a>Fragment</a> objects from the stream that meet the selector criteria. Results
         *        are in no specific order, even across pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragments(Collection<Fragment> fragments);

        /**
         * <p>
         * A list of archived <a>Fragment</a> objects from the stream that meet the selector criteria. Results are in no
         * specific order, even across pages.
         * </p>
         * 
         * @param fragments
         *        A list of archived <a>Fragment</a> objects from the stream that meet the selector criteria. Results
         *        are in no specific order, even across pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragments(Fragment... fragments);

        /**
         * <p>
         * A list of archived <a>Fragment</a> objects from the stream that meet the selector criteria. Results are in no
         * specific order, even across pages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment.Builder#build()} is called
         * immediately and its result is passed to {@link #fragments(List<Fragment>)}.
         * 
         * @param fragments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fragments(java.util.Collection<Fragment>)
         */
        Builder fragments(Consumer<Fragment.Builder>... fragments);

        /**
         * <p>
         * If the returned list is truncated, the operation returns this token to use to retrieve the next page of
         * results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        If the returned list is truncated, the operation returns this token to use to retrieve the next page
         *        of results. This value is <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisVideoArchivedMediaResponse.BuilderImpl implements Builder {
        private List<Fragment> fragments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFragmentsResponse model) {
            super(model);
            fragments(model.fragments);
            nextToken(model.nextToken);
        }

        public final List<Fragment.Builder> getFragments() {
            List<Fragment.Builder> result = FragmentListCopier.copyToBuilder(this.fragments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFragments(Collection<Fragment.BuilderImpl> fragments) {
            this.fragments = FragmentListCopier.copyFromBuilder(fragments);
        }

        @Override
        public final Builder fragments(Collection<Fragment> fragments) {
            this.fragments = FragmentListCopier.copy(fragments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(Fragment... fragments) {
            fragments(Arrays.asList(fragments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(Consumer<Fragment.Builder>... fragments) {
            fragments(Stream.of(fragments).map(c -> Fragment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFragmentsResponse build() {
            return new ListFragmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
