/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClipRequest extends KinesisVideoArchivedMediaRequest implements
        ToCopyableBuilder<GetClipRequest.Builder, GetClipRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(GetClipRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(GetClipRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<ClipFragmentSelector> CLIP_FRAGMENT_SELECTOR_FIELD = SdkField
            .<ClipFragmentSelector> builder(MarshallingType.SDK_POJO).memberName("ClipFragmentSelector")
            .getter(getter(GetClipRequest::clipFragmentSelector)).setter(setter(Builder::clipFragmentSelector))
            .constructor(ClipFragmentSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClipFragmentSelector").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, CLIP_FRAGMENT_SELECTOR_FIELD));

    private final String streamName;

    private final String streamARN;

    private final ClipFragmentSelector clipFragmentSelector;

    private GetClipRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.clipFragmentSelector = builder.clipFragmentSelector;
    }

    /**
     * <p>
     * The name of the stream for which to retrieve the media clip.
     * </p>
     * <p>
     * You must specify either the StreamName or the StreamARN.
     * </p>
     * 
     * @return The name of the stream for which to retrieve the media clip. </p>
     *         <p>
     *         You must specify either the StreamName or the StreamARN.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream for which to retrieve the media clip.
     * </p>
     * <p>
     * You must specify either the StreamName or the StreamARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream for which to retrieve the media clip. </p>
     *         <p>
     *         You must specify either the StreamName or the StreamARN.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The time range of the requested clip and the source of the timestamps.
     * </p>
     * 
     * @return The time range of the requested clip and the source of the timestamps.
     */
    public final ClipFragmentSelector clipFragmentSelector() {
        return clipFragmentSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(clipFragmentSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClipRequest)) {
            return false;
        }
        GetClipRequest other = (GetClipRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(clipFragmentSelector(), other.clipFragmentSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClipRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("ClipFragmentSelector", clipFragmentSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "ClipFragmentSelector":
            return Optional.ofNullable(clazz.cast(clipFragmentSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClipRequest, T> g) {
        return obj -> g.apply((GetClipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoArchivedMediaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetClipRequest> {
        /**
         * <p>
         * The name of the stream for which to retrieve the media clip.
         * </p>
         * <p>
         * You must specify either the StreamName or the StreamARN.
         * </p>
         * 
         * @param streamName
         *        The name of the stream for which to retrieve the media clip. </p>
         *        <p>
         *        You must specify either the StreamName or the StreamARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream for which to retrieve the media clip.
         * </p>
         * <p>
         * You must specify either the StreamName or the StreamARN.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream for which to retrieve the media clip. </p>
         *        <p>
         *        You must specify either the StreamName or the StreamARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The time range of the requested clip and the source of the timestamps.
         * </p>
         * 
         * @param clipFragmentSelector
         *        The time range of the requested clip and the source of the timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clipFragmentSelector(ClipFragmentSelector clipFragmentSelector);

        /**
         * <p>
         * The time range of the requested clip and the source of the timestamps.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClipFragmentSelector.Builder} avoiding
         * the need to create one manually via {@link ClipFragmentSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClipFragmentSelector.Builder#build()} is called immediately and
         * its result is passed to {@link #clipFragmentSelector(ClipFragmentSelector)}.
         * 
         * @param clipFragmentSelector
         *        a consumer that will call methods on {@link ClipFragmentSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clipFragmentSelector(ClipFragmentSelector)
         */
        default Builder clipFragmentSelector(Consumer<ClipFragmentSelector.Builder> clipFragmentSelector) {
            return clipFragmentSelector(ClipFragmentSelector.builder().applyMutation(clipFragmentSelector).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoArchivedMediaRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private ClipFragmentSelector clipFragmentSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClipRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            clipFragmentSelector(model.clipFragmentSelector);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final ClipFragmentSelector.Builder getClipFragmentSelector() {
            return clipFragmentSelector != null ? clipFragmentSelector.toBuilder() : null;
        }

        public final void setClipFragmentSelector(ClipFragmentSelector.BuilderImpl clipFragmentSelector) {
            this.clipFragmentSelector = clipFragmentSelector != null ? clipFragmentSelector.build() : null;
        }

        @Override
        public final Builder clipFragmentSelector(ClipFragmentSelector clipFragmentSelector) {
            this.clipFragmentSelector = clipFragmentSelector;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetClipRequest build() {
            return new GetClipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
