/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMappedResourceConfigurationResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<DescribeMappedResourceConfigurationResponse.Builder, DescribeMappedResourceConfigurationResponse> {
    private static final SdkField<List<MappedResourceConfigurationListItem>> MAPPED_RESOURCE_CONFIGURATION_LIST_FIELD = SdkField
            .<List<MappedResourceConfigurationListItem>> builder(MarshallingType.LIST)
            .memberName("MappedResourceConfigurationList")
            .getter(getter(DescribeMappedResourceConfigurationResponse::mappedResourceConfigurationList))
            .setter(setter(Builder::mappedResourceConfigurationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappedResourceConfigurationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MappedResourceConfigurationListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MappedResourceConfigurationListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMappedResourceConfigurationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAPPED_RESOURCE_CONFIGURATION_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<MappedResourceConfigurationListItem> mappedResourceConfigurationList;

    private final String nextToken;

    private DescribeMappedResourceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.mappedResourceConfigurationList = builder.mappedResourceConfigurationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MappedResourceConfigurationList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMappedResourceConfigurationList() {
        return mappedResourceConfigurationList != null && !(mappedResourceConfigurationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that encapsulates, or contains, the media storage configuration properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappedResourceConfigurationList}
     * method.
     * </p>
     * 
     * @return A structure that encapsulates, or contains, the media storage configuration properties.
     */
    public final List<MappedResourceConfigurationListItem> mappedResourceConfigurationList() {
        return mappedResourceConfigurationList;
    }

    /**
     * <p>
     * The token that was used in the <code>NextToken</code>request to fetch the next set of results.
     * </p>
     * 
     * @return The token that was used in the <code>NextToken</code>request to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMappedResourceConfigurationList() ? mappedResourceConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMappedResourceConfigurationResponse)) {
            return false;
        }
        DescribeMappedResourceConfigurationResponse other = (DescribeMappedResourceConfigurationResponse) obj;
        return hasMappedResourceConfigurationList() == other.hasMappedResourceConfigurationList()
                && Objects.equals(mappedResourceConfigurationList(), other.mappedResourceConfigurationList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeMappedResourceConfigurationResponse")
                .add("MappedResourceConfigurationList",
                        hasMappedResourceConfigurationList() ? mappedResourceConfigurationList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MappedResourceConfigurationList":
            return Optional.ofNullable(clazz.cast(mappedResourceConfigurationList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMappedResourceConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeMappedResourceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMappedResourceConfigurationResponse> {
        /**
         * <p>
         * A structure that encapsulates, or contains, the media storage configuration properties.
         * </p>
         * 
         * @param mappedResourceConfigurationList
         *        A structure that encapsulates, or contains, the media storage configuration properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedResourceConfigurationList(Collection<MappedResourceConfigurationListItem> mappedResourceConfigurationList);

        /**
         * <p>
         * A structure that encapsulates, or contains, the media storage configuration properties.
         * </p>
         * 
         * @param mappedResourceConfigurationList
         *        A structure that encapsulates, or contains, the media storage configuration properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedResourceConfigurationList(MappedResourceConfigurationListItem... mappedResourceConfigurationList);

        /**
         * <p>
         * A structure that encapsulates, or contains, the media storage configuration properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #mappedResourceConfigurationList(List<MappedResourceConfigurationListItem>)}.
         * 
         * @param mappedResourceConfigurationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappedResourceConfigurationList(java.util.Collection<MappedResourceConfigurationListItem>)
         */
        Builder mappedResourceConfigurationList(
                Consumer<MappedResourceConfigurationListItem.Builder>... mappedResourceConfigurationList);

        /**
         * <p>
         * The token that was used in the <code>NextToken</code>request to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token that was used in the <code>NextToken</code>request to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private List<MappedResourceConfigurationListItem> mappedResourceConfigurationList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMappedResourceConfigurationResponse model) {
            super(model);
            mappedResourceConfigurationList(model.mappedResourceConfigurationList);
            nextToken(model.nextToken);
        }

        public final List<MappedResourceConfigurationListItem.Builder> getMappedResourceConfigurationList() {
            List<MappedResourceConfigurationListItem.Builder> result = MappedResourceConfigurationListCopier
                    .copyToBuilder(this.mappedResourceConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedResourceConfigurationList(
                Collection<MappedResourceConfigurationListItem.BuilderImpl> mappedResourceConfigurationList) {
            this.mappedResourceConfigurationList = MappedResourceConfigurationListCopier
                    .copyFromBuilder(mappedResourceConfigurationList);
        }

        @Override
        public final Builder mappedResourceConfigurationList(
                Collection<MappedResourceConfigurationListItem> mappedResourceConfigurationList) {
            this.mappedResourceConfigurationList = MappedResourceConfigurationListCopier.copy(mappedResourceConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedResourceConfigurationList(
                MappedResourceConfigurationListItem... mappedResourceConfigurationList) {
            mappedResourceConfigurationList(Arrays.asList(mappedResourceConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedResourceConfigurationList(
                Consumer<MappedResourceConfigurationListItem.Builder>... mappedResourceConfigurationList) {
            mappedResourceConfigurationList(Stream.of(mappedResourceConfigurationList)
                    .map(c -> MappedResourceConfigurationListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMappedResourceConfigurationResponse build() {
            return new DescribeMappedResourceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
