/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the updates to the starting parameters for a Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RunConfigurationUpdate.Builder, RunConfigurationUpdate> {
    private static final SdkField<FlinkRunConfiguration> FLINK_RUN_CONFIGURATION_FIELD = SdkField
            .<FlinkRunConfiguration> builder(MarshallingType.SDK_POJO).memberName("FlinkRunConfiguration")
            .getter(getter(RunConfigurationUpdate::flinkRunConfiguration)).setter(setter(Builder::flinkRunConfiguration))
            .constructor(FlinkRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkRunConfiguration").build())
            .build();

    private static final SdkField<ApplicationRestoreConfiguration> APPLICATION_RESTORE_CONFIGURATION_FIELD = SdkField
            .<ApplicationRestoreConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationRestoreConfiguration")
            .getter(getter(RunConfigurationUpdate::applicationRestoreConfiguration))
            .setter(setter(Builder::applicationRestoreConfiguration))
            .constructor(ApplicationRestoreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationRestoreConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLINK_RUN_CONFIGURATION_FIELD,
            APPLICATION_RESTORE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FlinkRunConfiguration flinkRunConfiguration;

    private final ApplicationRestoreConfiguration applicationRestoreConfiguration;

    private RunConfigurationUpdate(BuilderImpl builder) {
        this.flinkRunConfiguration = builder.flinkRunConfiguration;
        this.applicationRestoreConfiguration = builder.applicationRestoreConfiguration;
    }

    /**
     * <p>
     * Describes the starting parameters for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes the starting parameters for a Flink-based Kinesis Data Analytics application.
     */
    public final FlinkRunConfiguration flinkRunConfiguration() {
        return flinkRunConfiguration;
    }

    /**
     * <p>
     * Describes updates to the restore behavior of a restarting application.
     * </p>
     * 
     * @return Describes updates to the restore behavior of a restarting application.
     */
    public final ApplicationRestoreConfiguration applicationRestoreConfiguration() {
        return applicationRestoreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flinkRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(applicationRestoreConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunConfigurationUpdate)) {
            return false;
        }
        RunConfigurationUpdate other = (RunConfigurationUpdate) obj;
        return Objects.equals(flinkRunConfiguration(), other.flinkRunConfiguration())
                && Objects.equals(applicationRestoreConfiguration(), other.applicationRestoreConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunConfigurationUpdate").add("FlinkRunConfiguration", flinkRunConfiguration())
                .add("ApplicationRestoreConfiguration", applicationRestoreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlinkRunConfiguration":
            return Optional.ofNullable(clazz.cast(flinkRunConfiguration()));
        case "ApplicationRestoreConfiguration":
            return Optional.ofNullable(clazz.cast(applicationRestoreConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunConfigurationUpdate, T> g) {
        return obj -> g.apply((RunConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunConfigurationUpdate> {
        /**
         * <p>
         * Describes the starting parameters for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param flinkRunConfiguration
         *        Describes the starting parameters for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flinkRunConfiguration(FlinkRunConfiguration flinkRunConfiguration);

        /**
         * <p>
         * Describes the starting parameters for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlinkRunConfiguration.Builder} avoiding
         * the need to create one manually via {@link FlinkRunConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlinkRunConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #flinkRunConfiguration(FlinkRunConfiguration)}.
         * 
         * @param flinkRunConfiguration
         *        a consumer that will call methods on {@link FlinkRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flinkRunConfiguration(FlinkRunConfiguration)
         */
        default Builder flinkRunConfiguration(Consumer<FlinkRunConfiguration.Builder> flinkRunConfiguration) {
            return flinkRunConfiguration(FlinkRunConfiguration.builder().applyMutation(flinkRunConfiguration).build());
        }

        /**
         * <p>
         * Describes updates to the restore behavior of a restarting application.
         * </p>
         * 
         * @param applicationRestoreConfiguration
         *        Describes updates to the restore behavior of a restarting application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationRestoreConfiguration(ApplicationRestoreConfiguration applicationRestoreConfiguration);

        /**
         * <p>
         * Describes updates to the restore behavior of a restarting application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationRestoreConfiguration.Builder}
         * avoiding the need to create one manually via {@link ApplicationRestoreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationRestoreConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationRestoreConfiguration(ApplicationRestoreConfiguration)}.
         * 
         * @param applicationRestoreConfiguration
         *        a consumer that will call methods on {@link ApplicationRestoreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationRestoreConfiguration(ApplicationRestoreConfiguration)
         */
        default Builder applicationRestoreConfiguration(
                Consumer<ApplicationRestoreConfiguration.Builder> applicationRestoreConfiguration) {
            return applicationRestoreConfiguration(ApplicationRestoreConfiguration.builder()
                    .applyMutation(applicationRestoreConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FlinkRunConfiguration flinkRunConfiguration;

        private ApplicationRestoreConfiguration applicationRestoreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RunConfigurationUpdate model) {
            flinkRunConfiguration(model.flinkRunConfiguration);
            applicationRestoreConfiguration(model.applicationRestoreConfiguration);
        }

        public final FlinkRunConfiguration.Builder getFlinkRunConfiguration() {
            return flinkRunConfiguration != null ? flinkRunConfiguration.toBuilder() : null;
        }

        public final void setFlinkRunConfiguration(FlinkRunConfiguration.BuilderImpl flinkRunConfiguration) {
            this.flinkRunConfiguration = flinkRunConfiguration != null ? flinkRunConfiguration.build() : null;
        }

        @Override
        public final Builder flinkRunConfiguration(FlinkRunConfiguration flinkRunConfiguration) {
            this.flinkRunConfiguration = flinkRunConfiguration;
            return this;
        }

        public final ApplicationRestoreConfiguration.Builder getApplicationRestoreConfiguration() {
            return applicationRestoreConfiguration != null ? applicationRestoreConfiguration.toBuilder() : null;
        }

        public final void setApplicationRestoreConfiguration(
                ApplicationRestoreConfiguration.BuilderImpl applicationRestoreConfiguration) {
            this.applicationRestoreConfiguration = applicationRestoreConfiguration != null ? applicationRestoreConfiguration
                    .build() : null;
        }

        @Override
        public final Builder applicationRestoreConfiguration(ApplicationRestoreConfiguration applicationRestoreConfiguration) {
            this.applicationRestoreConfiguration = applicationRestoreConfiguration;
            return this;
        }

        @Override
        public RunConfigurationUpdate build() {
            return new RunConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
