/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that specifies the TLS configuration for a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TlsConfig implements SdkPojo, Serializable, ToCopyableBuilder<TlsConfig.Builder, TlsConfig> {
    private static final SdkField<String> SECURITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityPolicy").getter(getter(TlsConfig::securityPolicy)).setter(setter(Builder::securityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String securityPolicy;

    private TlsConfig(BuilderImpl builder) {
        this.securityPolicy = builder.securityPolicy;
    }

    /**
     * <p>
     * The security policy for a domain configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html#tls-policy-table">Security
     * policies </a> in the <i>Amazon Web Services IoT Core developer guide</i>.
     * </p>
     * 
     * @return The security policy for a domain configuration. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html#tls-policy-table"
     *         >Security policies </a> in the <i>Amazon Web Services IoT Core developer guide</i>.
     */
    public final String securityPolicy() {
        return securityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsConfig)) {
            return false;
        }
        TlsConfig other = (TlsConfig) obj;
        return Objects.equals(securityPolicy(), other.securityPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TlsConfig").add("SecurityPolicy", securityPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityPolicy":
            return Optional.ofNullable(clazz.cast(securityPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TlsConfig, T> g) {
        return obj -> g.apply((TlsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TlsConfig> {
        /**
         * <p>
         * The security policy for a domain configuration. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html#tls-policy-table"
         * >Security policies </a> in the <i>Amazon Web Services IoT Core developer guide</i>.
         * </p>
         * 
         * @param securityPolicy
         *        The security policy for a domain configuration. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html#tls-policy-table"
         *        >Security policies </a> in the <i>Amazon Web Services IoT Core developer guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicy(String securityPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String securityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(TlsConfig model) {
            securityPolicy(model.securityPolicy);
        }

        public final String getSecurityPolicy() {
            return securityPolicy;
        }

        public final void setSecurityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
        }

        @Override
        public final Builder securityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        @Override
        public TlsConfig build() {
            return new TlsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
