/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Set configurations for metrics export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsExportConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricsExportConfig.Builder, MetricsExportConfig> {
    private static final SdkField<String> MQTT_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mqttTopic").getter(getter(MetricsExportConfig::mqttTopic)).setter(setter(Builder::mqttTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttTopic").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(MetricsExportConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MQTT_TOPIC_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mqttTopic;

    private final String roleArn;

    private MetricsExportConfig(BuilderImpl builder) {
        this.mqttTopic = builder.mqttTopic;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The MQTT topic that Device Defender Detect should publish messages to for metrics export.
     * </p>
     * 
     * @return The MQTT topic that Device Defender Detect should publish messages to for metrics export.
     */
    public final String mqttTopic() {
        return mqttTopic;
    }

    /**
     * <p>
     * This role ARN has permission to publish MQTT messages, after which Device Defender Detect can assume the role and
     * publish messages on your behalf.
     * </p>
     * 
     * @return This role ARN has permission to publish MQTT messages, after which Device Defender Detect can assume the
     *         role and publish messages on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mqttTopic());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsExportConfig)) {
            return false;
        }
        MetricsExportConfig other = (MetricsExportConfig) obj;
        return Objects.equals(mqttTopic(), other.mqttTopic()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricsExportConfig").add("MqttTopic", mqttTopic()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mqttTopic":
            return Optional.ofNullable(clazz.cast(mqttTopic()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricsExportConfig, T> g) {
        return obj -> g.apply((MetricsExportConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsExportConfig> {
        /**
         * <p>
         * The MQTT topic that Device Defender Detect should publish messages to for metrics export.
         * </p>
         * 
         * @param mqttTopic
         *        The MQTT topic that Device Defender Detect should publish messages to for metrics export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mqttTopic(String mqttTopic);

        /**
         * <p>
         * This role ARN has permission to publish MQTT messages, after which Device Defender Detect can assume the role
         * and publish messages on your behalf.
         * </p>
         * 
         * @param roleArn
         *        This role ARN has permission to publish MQTT messages, after which Device Defender Detect can assume
         *        the role and publish messages on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String mqttTopic;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsExportConfig model) {
            mqttTopic(model.mqttTopic);
            roleArn(model.roleArn);
        }

        public final String getMqttTopic() {
            return mqttTopic;
        }

        public final void setMqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
        }

        @Override
        public final Builder mqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public MetricsExportConfig build() {
            return new MetricsExportConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
