/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMemberDetectorsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetMemberDetectorsResponse.Builder, GetMemberDetectorsResponse> {
    private static final SdkField<List<MemberDataSourceConfiguration>> MEMBER_DATA_SOURCE_CONFIGURATIONS_FIELD = SdkField
            .<List<MemberDataSourceConfiguration>> builder(MarshallingType.LIST)
            .memberName("MemberDataSourceConfigurations")
            .getter(getter(GetMemberDetectorsResponse::memberDataSourceConfigurations))
            .setter(setter(Builder::memberDataSourceConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDataSourceConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDataSourceConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAccounts")
            .getter(getter(GetMemberDetectorsResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEMBER_DATA_SOURCE_CONFIGURATIONS_FIELD, UNPROCESSED_ACCOUNTS_FIELD));

    private final List<MemberDataSourceConfiguration> memberDataSourceConfigurations;

    private final List<UnprocessedAccount> unprocessedAccounts;

    private GetMemberDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.memberDataSourceConfigurations = builder.memberDataSourceConfigurations;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberDataSourceConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMemberDataSourceConfigurations() {
        return memberDataSourceConfigurations != null && !(memberDataSourceConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that describes which data sources are enabled for a member account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberDataSourceConfigurations} method.
     * </p>
     * 
     * @return An object that describes which data sources are enabled for a member account.
     */
    public final List<MemberDataSourceConfiguration> memberDataSourceConfigurations() {
        return memberDataSourceConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of member account IDs that were unable to be processed along with an explanation for why they were not
     * processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedAccounts} method.
     * </p>
     * 
     * @return A list of member account IDs that were unable to be processed along with an explanation for why they were
     *         not processed.
     */
    public final List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMemberDataSourceConfigurations() ? memberDataSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMemberDetectorsResponse)) {
            return false;
        }
        GetMemberDetectorsResponse other = (GetMemberDetectorsResponse) obj;
        return hasMemberDataSourceConfigurations() == other.hasMemberDataSourceConfigurations()
                && Objects.equals(memberDataSourceConfigurations(), other.memberDataSourceConfigurations())
                && hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetMemberDetectorsResponse")
                .add("MemberDataSourceConfigurations",
                        hasMemberDataSourceConfigurations() ? memberDataSourceConfigurations() : null)
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberDataSourceConfigurations":
            return Optional.ofNullable(clazz.cast(memberDataSourceConfigurations()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMemberDetectorsResponse, T> g) {
        return obj -> g.apply((GetMemberDetectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMemberDetectorsResponse> {
        /**
         * <p>
         * An object that describes which data sources are enabled for a member account.
         * </p>
         * 
         * @param memberDataSourceConfigurations
         *        An object that describes which data sources are enabled for a member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDataSourceConfigurations(Collection<MemberDataSourceConfiguration> memberDataSourceConfigurations);

        /**
         * <p>
         * An object that describes which data sources are enabled for a member account.
         * </p>
         * 
         * @param memberDataSourceConfigurations
         *        An object that describes which data sources are enabled for a member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDataSourceConfigurations(MemberDataSourceConfiguration... memberDataSourceConfigurations);

        /**
         * <p>
         * An object that describes which data sources are enabled for a member account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #memberDataSourceConfigurations(List<MemberDataSourceConfiguration>)}.
         * 
         * @param memberDataSourceConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDataSourceConfigurations(java.util.Collection<MemberDataSourceConfiguration>)
         */
        Builder memberDataSourceConfigurations(Consumer<MemberDataSourceConfiguration.Builder>... memberDataSourceConfigurations);

        /**
         * <p>
         * A list of member account IDs that were unable to be processed along with an explanation for why they were not
         * processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        A list of member account IDs that were unable to be processed along with an explanation for why they
         *        were not processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * A list of member account IDs that were unable to be processed along with an explanation for why they were not
         * processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        A list of member account IDs that were unable to be processed along with an explanation for why they
         *        were not processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * A list of member account IDs that were unable to be processed along with an explanation for why they were not
         * processed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UnprocessedAccount.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.guardduty.model.UnprocessedAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UnprocessedAccount.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UnprocessedAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(java.util.Collection<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<MemberDataSourceConfiguration> memberDataSourceConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMemberDetectorsResponse model) {
            super(model);
            memberDataSourceConfigurations(model.memberDataSourceConfigurations);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<MemberDataSourceConfiguration.Builder> getMemberDataSourceConfigurations() {
            List<MemberDataSourceConfiguration.Builder> result = MemberDataSourceConfigurationsCopier
                    .copyToBuilder(this.memberDataSourceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberDataSourceConfigurations(
                Collection<MemberDataSourceConfiguration.BuilderImpl> memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations = MemberDataSourceConfigurationsCopier
                    .copyFromBuilder(memberDataSourceConfigurations);
        }

        @Override
        public final Builder memberDataSourceConfigurations(
                Collection<MemberDataSourceConfiguration> memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations = MemberDataSourceConfigurationsCopier.copy(memberDataSourceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDataSourceConfigurations(MemberDataSourceConfiguration... memberDataSourceConfigurations) {
            memberDataSourceConfigurations(Arrays.asList(memberDataSourceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDataSourceConfigurations(
                Consumer<MemberDataSourceConfiguration.Builder>... memberDataSourceConfigurations) {
            memberDataSourceConfigurations(Stream.of(memberDataSourceConfigurations)
                    .map(c -> MemberDataSourceConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = UnprocessedAccountsCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMemberDetectorsResponse build() {
            return new GetMemberDetectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
