/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains list of scanned and skipped EBS volumes with details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsVolumeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsVolumeDetails.Builder, EbsVolumeDetails> {
    private static final SdkField<List<VolumeDetail>> SCANNED_VOLUME_DETAILS_FIELD = SdkField
            .<List<VolumeDetail>> builder(MarshallingType.LIST)
            .memberName("ScannedVolumeDetails")
            .getter(getter(EbsVolumeDetails::scannedVolumeDetails))
            .setter(setter(Builder::scannedVolumeDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedVolumeDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VolumeDetail>> SKIPPED_VOLUME_DETAILS_FIELD = SdkField
            .<List<VolumeDetail>> builder(MarshallingType.LIST)
            .memberName("SkippedVolumeDetails")
            .getter(getter(EbsVolumeDetails::skippedVolumeDetails))
            .setter(setter(Builder::skippedVolumeDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedVolumeDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANNED_VOLUME_DETAILS_FIELD,
            SKIPPED_VOLUME_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<VolumeDetail> scannedVolumeDetails;

    private final List<VolumeDetail> skippedVolumeDetails;

    private EbsVolumeDetails(BuilderImpl builder) {
        this.scannedVolumeDetails = builder.scannedVolumeDetails;
        this.skippedVolumeDetails = builder.skippedVolumeDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScannedVolumeDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScannedVolumeDetails() {
        return scannedVolumeDetails != null && !(scannedVolumeDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of EBS volumes that were scanned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScannedVolumeDetails} method.
     * </p>
     * 
     * @return List of EBS volumes that were scanned.
     */
    public final List<VolumeDetail> scannedVolumeDetails() {
        return scannedVolumeDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the SkippedVolumeDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSkippedVolumeDetails() {
        return skippedVolumeDetails != null && !(skippedVolumeDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of EBS volumes that were skipped from the malware scan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSkippedVolumeDetails} method.
     * </p>
     * 
     * @return List of EBS volumes that were skipped from the malware scan.
     */
    public final List<VolumeDetail> skippedVolumeDetails() {
        return skippedVolumeDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasScannedVolumeDetails() ? scannedVolumeDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSkippedVolumeDetails() ? skippedVolumeDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolumeDetails)) {
            return false;
        }
        EbsVolumeDetails other = (EbsVolumeDetails) obj;
        return hasScannedVolumeDetails() == other.hasScannedVolumeDetails()
                && Objects.equals(scannedVolumeDetails(), other.scannedVolumeDetails())
                && hasSkippedVolumeDetails() == other.hasSkippedVolumeDetails()
                && Objects.equals(skippedVolumeDetails(), other.skippedVolumeDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsVolumeDetails")
                .add("ScannedVolumeDetails", hasScannedVolumeDetails() ? scannedVolumeDetails() : null)
                .add("SkippedVolumeDetails", hasSkippedVolumeDetails() ? skippedVolumeDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScannedVolumeDetails":
            return Optional.ofNullable(clazz.cast(scannedVolumeDetails()));
        case "SkippedVolumeDetails":
            return Optional.ofNullable(clazz.cast(skippedVolumeDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsVolumeDetails, T> g) {
        return obj -> g.apply((EbsVolumeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsVolumeDetails> {
        /**
         * <p>
         * List of EBS volumes that were scanned.
         * </p>
         * 
         * @param scannedVolumeDetails
         *        List of EBS volumes that were scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scannedVolumeDetails(Collection<VolumeDetail> scannedVolumeDetails);

        /**
         * <p>
         * List of EBS volumes that were scanned.
         * </p>
         * 
         * @param scannedVolumeDetails
         *        List of EBS volumes that were scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scannedVolumeDetails(VolumeDetail... scannedVolumeDetails);

        /**
         * <p>
         * List of EBS volumes that were scanned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #scannedVolumeDetails(List<VolumeDetail>)}.
         * 
         * @param scannedVolumeDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scannedVolumeDetails(java.util.Collection<VolumeDetail>)
         */
        Builder scannedVolumeDetails(Consumer<VolumeDetail.Builder>... scannedVolumeDetails);

        /**
         * <p>
         * List of EBS volumes that were skipped from the malware scan.
         * </p>
         * 
         * @param skippedVolumeDetails
         *        List of EBS volumes that were skipped from the malware scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedVolumeDetails(Collection<VolumeDetail> skippedVolumeDetails);

        /**
         * <p>
         * List of EBS volumes that were skipped from the malware scan.
         * </p>
         * 
         * @param skippedVolumeDetails
         *        List of EBS volumes that were skipped from the malware scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedVolumeDetails(VolumeDetail... skippedVolumeDetails);

        /**
         * <p>
         * List of EBS volumes that were skipped from the malware scan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #skippedVolumeDetails(List<VolumeDetail>)}.
         * 
         * @param skippedVolumeDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.VolumeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skippedVolumeDetails(java.util.Collection<VolumeDetail>)
         */
        Builder skippedVolumeDetails(Consumer<VolumeDetail.Builder>... skippedVolumeDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<VolumeDetail> scannedVolumeDetails = DefaultSdkAutoConstructList.getInstance();

        private List<VolumeDetail> skippedVolumeDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolumeDetails model) {
            scannedVolumeDetails(model.scannedVolumeDetails);
            skippedVolumeDetails(model.skippedVolumeDetails);
        }

        public final List<VolumeDetail.Builder> getScannedVolumeDetails() {
            List<VolumeDetail.Builder> result = VolumeDetailsCopier.copyToBuilder(this.scannedVolumeDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScannedVolumeDetails(Collection<VolumeDetail.BuilderImpl> scannedVolumeDetails) {
            this.scannedVolumeDetails = VolumeDetailsCopier.copyFromBuilder(scannedVolumeDetails);
        }

        @Override
        public final Builder scannedVolumeDetails(Collection<VolumeDetail> scannedVolumeDetails) {
            this.scannedVolumeDetails = VolumeDetailsCopier.copy(scannedVolumeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scannedVolumeDetails(VolumeDetail... scannedVolumeDetails) {
            scannedVolumeDetails(Arrays.asList(scannedVolumeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scannedVolumeDetails(Consumer<VolumeDetail.Builder>... scannedVolumeDetails) {
            scannedVolumeDetails(Stream.of(scannedVolumeDetails).map(c -> VolumeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<VolumeDetail.Builder> getSkippedVolumeDetails() {
            List<VolumeDetail.Builder> result = VolumeDetailsCopier.copyToBuilder(this.skippedVolumeDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkippedVolumeDetails(Collection<VolumeDetail.BuilderImpl> skippedVolumeDetails) {
            this.skippedVolumeDetails = VolumeDetailsCopier.copyFromBuilder(skippedVolumeDetails);
        }

        @Override
        public final Builder skippedVolumeDetails(Collection<VolumeDetail> skippedVolumeDetails) {
            this.skippedVolumeDetails = VolumeDetailsCopier.copy(skippedVolumeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedVolumeDetails(VolumeDetail... skippedVolumeDetails) {
            skippedVolumeDetails(Arrays.asList(skippedVolumeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedVolumeDetails(Consumer<VolumeDetail.Builder>... skippedVolumeDetails) {
            skippedVolumeDetails(Stream.of(skippedVolumeDetails).map(c -> VolumeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EbsVolumeDetails build() {
            return new EbsVolumeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
