/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the resource for each individual EKS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageResourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageResourceDetails.Builder, CoverageResourceDetails> {
    private static final SdkField<CoverageEksClusterDetails> EKS_CLUSTER_DETAILS_FIELD = SdkField
            .<CoverageEksClusterDetails> builder(MarshallingType.SDK_POJO).memberName("EksClusterDetails")
            .getter(getter(CoverageResourceDetails::eksClusterDetails)).setter(setter(Builder::eksClusterDetails))
            .constructor(CoverageEksClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterDetails").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(CoverageResourceDetails::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<CoverageEcsClusterDetails> ECS_CLUSTER_DETAILS_FIELD = SdkField
            .<CoverageEcsClusterDetails> builder(MarshallingType.SDK_POJO).memberName("EcsClusterDetails")
            .getter(getter(CoverageResourceDetails::ecsClusterDetails)).setter(setter(Builder::ecsClusterDetails))
            .constructor(CoverageEcsClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsClusterDetails").build()).build();

    private static final SdkField<CoverageEc2InstanceDetails> EC2_INSTANCE_DETAILS_FIELD = SdkField
            .<CoverageEc2InstanceDetails> builder(MarshallingType.SDK_POJO).memberName("Ec2InstanceDetails")
            .getter(getter(CoverageResourceDetails::ec2InstanceDetails)).setter(setter(Builder::ec2InstanceDetails))
            .constructor(CoverageEc2InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_DETAILS_FIELD,
            RESOURCE_TYPE_FIELD, ECS_CLUSTER_DETAILS_FIELD, EC2_INSTANCE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CoverageEksClusterDetails eksClusterDetails;

    private final String resourceType;

    private final CoverageEcsClusterDetails ecsClusterDetails;

    private final CoverageEc2InstanceDetails ec2InstanceDetails;

    private CoverageResourceDetails(BuilderImpl builder) {
        this.eksClusterDetails = builder.eksClusterDetails;
        this.resourceType = builder.resourceType;
        this.ecsClusterDetails = builder.ecsClusterDetails;
        this.ec2InstanceDetails = builder.ec2InstanceDetails;
    }

    /**
     * <p>
     * EKS cluster details involved in the coverage statistics.
     * </p>
     * 
     * @return EKS cluster details involved in the coverage statistics.
     */
    public final CoverageEksClusterDetails eksClusterDetails() {
        return eksClusterDetails;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services resource.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of Amazon Web Services resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services resource.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Information about the Amazon ECS cluster that is assessed for runtime coverage.
     * </p>
     * 
     * @return Information about the Amazon ECS cluster that is assessed for runtime coverage.
     */
    public final CoverageEcsClusterDetails ecsClusterDetails() {
        return ecsClusterDetails;
    }

    /**
     * <note>
     * <p>
     * This API is also used when you use GuardDuty Runtime Monitoring for your Amazon EC2 instances (currently in
     * preview release) and is subject to change. The use of this API is subject to Section 2 of the <a
     * href="http://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> ("Betas and Previews").
     * </p>
     * </note>
     * <p>
     * Information about the Amazon EC2 instance assessed for runtime coverage.
     * </p>
     * 
     * @return <p>
     *         This API is also used when you use GuardDuty Runtime Monitoring for your Amazon EC2 instances (currently
     *         in preview release) and is subject to change. The use of this API is subject to Section 2 of the <a
     *         href="http://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> ("Betas and Previews").
     *         </p>
     *         </note>
     *         <p>
     *         Information about the Amazon EC2 instance assessed for runtime coverage.
     */
    public final CoverageEc2InstanceDetails ec2InstanceDetails() {
        return ec2InstanceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageResourceDetails)) {
            return false;
        }
        CoverageResourceDetails other = (CoverageResourceDetails) obj;
        return Objects.equals(eksClusterDetails(), other.eksClusterDetails())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(ecsClusterDetails(), other.ecsClusterDetails())
                && Objects.equals(ec2InstanceDetails(), other.ec2InstanceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageResourceDetails").add("EksClusterDetails", eksClusterDetails())
                .add("ResourceType", resourceTypeAsString()).add("EcsClusterDetails", ecsClusterDetails())
                .add("Ec2InstanceDetails", ec2InstanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EksClusterDetails":
            return Optional.ofNullable(clazz.cast(eksClusterDetails()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "EcsClusterDetails":
            return Optional.ofNullable(clazz.cast(ecsClusterDetails()));
        case "Ec2InstanceDetails":
            return Optional.ofNullable(clazz.cast(ec2InstanceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageResourceDetails, T> g) {
        return obj -> g.apply((CoverageResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageResourceDetails> {
        /**
         * <p>
         * EKS cluster details involved in the coverage statistics.
         * </p>
         * 
         * @param eksClusterDetails
         *        EKS cluster details involved in the coverage statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusterDetails(CoverageEksClusterDetails eksClusterDetails);

        /**
         * <p>
         * EKS cluster details involved in the coverage statistics.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageEksClusterDetails.Builder}
         * avoiding the need to create one manually via {@link CoverageEksClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageEksClusterDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #eksClusterDetails(CoverageEksClusterDetails)}.
         * 
         * @param eksClusterDetails
         *        a consumer that will call methods on {@link CoverageEksClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksClusterDetails(CoverageEksClusterDetails)
         */
        default Builder eksClusterDetails(Consumer<CoverageEksClusterDetails.Builder> eksClusterDetails) {
            return eksClusterDetails(CoverageEksClusterDetails.builder().applyMutation(eksClusterDetails).build());
        }

        /**
         * <p>
         * The type of Amazon Web Services resource.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of Amazon Web Services resource.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Information about the Amazon ECS cluster that is assessed for runtime coverage.
         * </p>
         * 
         * @param ecsClusterDetails
         *        Information about the Amazon ECS cluster that is assessed for runtime coverage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterDetails(CoverageEcsClusterDetails ecsClusterDetails);

        /**
         * <p>
         * Information about the Amazon ECS cluster that is assessed for runtime coverage.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageEcsClusterDetails.Builder}
         * avoiding the need to create one manually via {@link CoverageEcsClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageEcsClusterDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #ecsClusterDetails(CoverageEcsClusterDetails)}.
         * 
         * @param ecsClusterDetails
         *        a consumer that will call methods on {@link CoverageEcsClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsClusterDetails(CoverageEcsClusterDetails)
         */
        default Builder ecsClusterDetails(Consumer<CoverageEcsClusterDetails.Builder> ecsClusterDetails) {
            return ecsClusterDetails(CoverageEcsClusterDetails.builder().applyMutation(ecsClusterDetails).build());
        }

        /**
         * <note>
         * <p>
         * This API is also used when you use GuardDuty Runtime Monitoring for your Amazon EC2 instances (currently in
         * preview release) and is subject to change. The use of this API is subject to Section 2 of the <a
         * href="http://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> ("Betas and Previews").
         * </p>
         * </note>
         * <p>
         * Information about the Amazon EC2 instance assessed for runtime coverage.
         * </p>
         * 
         * @param ec2InstanceDetails
         *        <p>
         *        This API is also used when you use GuardDuty Runtime Monitoring for your Amazon EC2 instances
         *        (currently in preview release) and is subject to change. The use of this API is subject to Section 2
         *        of the <a href="http://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a>
         *        ("Betas and Previews").
         *        </p>
         *        </note>
         *        <p>
         *        Information about the Amazon EC2 instance assessed for runtime coverage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceDetails(CoverageEc2InstanceDetails ec2InstanceDetails);

        /**
         * <note>
         * <p>
         * This API is also used when you use GuardDuty Runtime Monitoring for your Amazon EC2 instances (currently in
         * preview release) and is subject to change. The use of this API is subject to Section 2 of the <a
         * href="http://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> ("Betas and Previews").
         * </p>
         * </note>
         * <p>
         * Information about the Amazon EC2 instance assessed for runtime coverage.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageEc2InstanceDetails.Builder}
         * avoiding the need to create one manually via {@link CoverageEc2InstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageEc2InstanceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2InstanceDetails(CoverageEc2InstanceDetails)}.
         * 
         * @param ec2InstanceDetails
         *        a consumer that will call methods on {@link CoverageEc2InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceDetails(CoverageEc2InstanceDetails)
         */
        default Builder ec2InstanceDetails(Consumer<CoverageEc2InstanceDetails.Builder> ec2InstanceDetails) {
            return ec2InstanceDetails(CoverageEc2InstanceDetails.builder().applyMutation(ec2InstanceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CoverageEksClusterDetails eksClusterDetails;

        private String resourceType;

        private CoverageEcsClusterDetails ecsClusterDetails;

        private CoverageEc2InstanceDetails ec2InstanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageResourceDetails model) {
            eksClusterDetails(model.eksClusterDetails);
            resourceType(model.resourceType);
            ecsClusterDetails(model.ecsClusterDetails);
            ec2InstanceDetails(model.ec2InstanceDetails);
        }

        public final CoverageEksClusterDetails.Builder getEksClusterDetails() {
            return eksClusterDetails != null ? eksClusterDetails.toBuilder() : null;
        }

        public final void setEksClusterDetails(CoverageEksClusterDetails.BuilderImpl eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails != null ? eksClusterDetails.build() : null;
        }

        @Override
        public final Builder eksClusterDetails(CoverageEksClusterDetails eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final CoverageEcsClusterDetails.Builder getEcsClusterDetails() {
            return ecsClusterDetails != null ? ecsClusterDetails.toBuilder() : null;
        }

        public final void setEcsClusterDetails(CoverageEcsClusterDetails.BuilderImpl ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails != null ? ecsClusterDetails.build() : null;
        }

        @Override
        public final Builder ecsClusterDetails(CoverageEcsClusterDetails ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails;
            return this;
        }

        public final CoverageEc2InstanceDetails.Builder getEc2InstanceDetails() {
            return ec2InstanceDetails != null ? ec2InstanceDetails.toBuilder() : null;
        }

        public final void setEc2InstanceDetails(CoverageEc2InstanceDetails.BuilderImpl ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails != null ? ec2InstanceDetails.build() : null;
        }

        @Override
        public final Builder ec2InstanceDetails(CoverageEc2InstanceDetails ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails;
            return this;
        }

        @Override
        public CoverageResourceDetails build() {
            return new CoverageResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
