/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the unusual anomalies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyObject implements SdkPojo, Serializable, ToCopyableBuilder<AnomalyObject.Builder, AnomalyObject> {
    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileType").getter(getter(AnomalyObject::profileTypeAsString)).setter(setter(Builder::profileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileType").build()).build();

    private static final SdkField<String> PROFILE_SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileSubtype").getter(getter(AnomalyObject::profileSubtypeAsString))
            .setter(setter(Builder::profileSubtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileSubtype").build()).build();

    private static final SdkField<Observations> OBSERVATIONS_FIELD = SdkField.<Observations> builder(MarshallingType.SDK_POJO)
            .memberName("Observations").getter(getter(AnomalyObject::observations)).setter(setter(Builder::observations))
            .constructor(Observations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_TYPE_FIELD,
            PROFILE_SUBTYPE_FIELD, OBSERVATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profileType;

    private final String profileSubtype;

    private final Observations observations;

    private AnomalyObject(BuilderImpl builder) {
        this.profileType = builder.profileType;
        this.profileSubtype = builder.profileSubtype;
        this.observations = builder.observations;
    }

    /**
     * <p>
     * The type of behavior of the profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return The type of behavior of the profile.
     * @see ProfileType
     */
    public final ProfileType profileType() {
        return ProfileType.fromValue(profileType);
    }

    /**
     * <p>
     * The type of behavior of the profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return The type of behavior of the profile.
     * @see ProfileType
     */
    public final String profileTypeAsString() {
        return profileType;
    }

    /**
     * <p>
     * The frequency of the anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileSubtype}
     * will return {@link ProfileSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #profileSubtypeAsString}.
     * </p>
     * 
     * @return The frequency of the anomaly.
     * @see ProfileSubtype
     */
    public final ProfileSubtype profileSubtype() {
        return ProfileSubtype.fromValue(profileSubtype);
    }

    /**
     * <p>
     * The frequency of the anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileSubtype}
     * will return {@link ProfileSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #profileSubtypeAsString}.
     * </p>
     * 
     * @return The frequency of the anomaly.
     * @see ProfileSubtype
     */
    public final String profileSubtypeAsString() {
        return profileSubtype;
    }

    /**
     * <p>
     * The recorded value.
     * </p>
     * 
     * @return The recorded value.
     */
    public final Observations observations() {
        return observations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(observations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyObject)) {
            return false;
        }
        AnomalyObject other = (AnomalyObject) obj;
        return Objects.equals(profileTypeAsString(), other.profileTypeAsString())
                && Objects.equals(profileSubtypeAsString(), other.profileSubtypeAsString())
                && Objects.equals(observations(), other.observations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyObject").add("ProfileType", profileTypeAsString())
                .add("ProfileSubtype", profileSubtypeAsString()).add("Observations", observations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileType":
            return Optional.ofNullable(clazz.cast(profileTypeAsString()));
        case "ProfileSubtype":
            return Optional.ofNullable(clazz.cast(profileSubtypeAsString()));
        case "Observations":
            return Optional.ofNullable(clazz.cast(observations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyObject, T> g) {
        return obj -> g.apply((AnomalyObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyObject> {
        /**
         * <p>
         * The type of behavior of the profile.
         * </p>
         * 
         * @param profileType
         *        The type of behavior of the profile.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(String profileType);

        /**
         * <p>
         * The type of behavior of the profile.
         * </p>
         * 
         * @param profileType
         *        The type of behavior of the profile.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(ProfileType profileType);

        /**
         * <p>
         * The frequency of the anomaly.
         * </p>
         * 
         * @param profileSubtype
         *        The frequency of the anomaly.
         * @see ProfileSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileSubtype
         */
        Builder profileSubtype(String profileSubtype);

        /**
         * <p>
         * The frequency of the anomaly.
         * </p>
         * 
         * @param profileSubtype
         *        The frequency of the anomaly.
         * @see ProfileSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileSubtype
         */
        Builder profileSubtype(ProfileSubtype profileSubtype);

        /**
         * <p>
         * The recorded value.
         * </p>
         * 
         * @param observations
         *        The recorded value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observations(Observations observations);

        /**
         * <p>
         * The recorded value.
         * </p>
         * This is a convenience method that creates an instance of the {@link Observations.Builder} avoiding the need
         * to create one manually via {@link Observations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Observations.Builder#build()} is called immediately and its
         * result is passed to {@link #observations(Observations)}.
         * 
         * @param observations
         *        a consumer that will call methods on {@link Observations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observations(Observations)
         */
        default Builder observations(Consumer<Observations.Builder> observations) {
            return observations(Observations.builder().applyMutation(observations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String profileType;

        private String profileSubtype;

        private Observations observations;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyObject model) {
            profileType(model.profileType);
            profileSubtype(model.profileSubtype);
            observations(model.observations);
        }

        public final String getProfileType() {
            return profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public final Builder profileType(ProfileType profileType) {
            this.profileType(profileType == null ? null : profileType.toString());
            return this;
        }

        public final String getProfileSubtype() {
            return profileSubtype;
        }

        public final void setProfileSubtype(String profileSubtype) {
            this.profileSubtype = profileSubtype;
        }

        @Override
        public final Builder profileSubtype(String profileSubtype) {
            this.profileSubtype = profileSubtype;
            return this;
        }

        @Override
        public final Builder profileSubtype(ProfileSubtype profileSubtype) {
            this.profileSubtype(profileSubtype == null ? null : profileSubtype.toString());
            return this;
        }

        public final Observations.Builder getObservations() {
            return observations != null ? observations.toBuilder() : null;
        }

        public final void setObservations(Observations.BuilderImpl observations) {
            this.observations = observations != null ? observations.build() : null;
        }

        @Override
        public final Builder observations(Observations observations) {
            this.observations = observations;
            return this;
        }

        @Override
        public AnomalyObject build() {
            return new AnomalyObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
