/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSourceControlFromJobRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateSourceControlFromJobRequest.Builder, UpdateSourceControlFromJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(UpdateSourceControlFromJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Provider").getter(getter(UpdateSourceControlFromJobRequest::providerAsString))
            .setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(UpdateSourceControlFromJobRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryOwner").getter(getter(UpdateSourceControlFromJobRequest::repositoryOwner))
            .setter(setter(Builder::repositoryOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryOwner").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BranchName").getter(getter(UpdateSourceControlFromJobRequest::branchName))
            .setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchName").build()).build();

    private static final SdkField<String> FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Folder")
            .getter(getter(UpdateSourceControlFromJobRequest::folder)).setter(setter(Builder::folder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folder").build()).build();

    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitId").getter(getter(UpdateSourceControlFromJobRequest::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitId").build()).build();

    private static final SdkField<String> AUTH_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthStrategy").getter(getter(UpdateSourceControlFromJobRequest::authStrategyAsString))
            .setter(setter(Builder::authStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthStrategy").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(UpdateSourceControlFromJobRequest::authToken))
            .setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            PROVIDER_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_OWNER_FIELD, BRANCH_NAME_FIELD, FOLDER_FIELD, COMMIT_ID_FIELD,
            AUTH_STRATEGY_FIELD, AUTH_TOKEN_FIELD));

    private final String jobName;

    private final String provider;

    private final String repositoryName;

    private final String repositoryOwner;

    private final String branchName;

    private final String folder;

    private final String commitId;

    private final String authStrategy;

    private final String authToken;

    private UpdateSourceControlFromJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.provider = builder.provider;
        this.repositoryName = builder.repositoryName;
        this.repositoryOwner = builder.repositoryOwner;
        this.branchName = builder.branchName;
        this.folder = builder.folder;
        this.commitId = builder.commitId;
        this.authStrategy = builder.authStrategy;
        this.authToken = builder.authToken;
    }

    /**
     * <p>
     * The name of the Glue job to be synchronized to or from the remote repository.
     * </p>
     * 
     * @return The name of the Glue job to be synchronized to or from the remote repository.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link SourceControlProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
     * @see SourceControlProvider
     */
    public final SourceControlProvider provider() {
        return SourceControlProvider.fromValue(provider);
    }

    /**
     * <p>
     * The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link SourceControlProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
     * @see SourceControlProvider
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * The name of the remote repository that contains the job artifacts. For BitBucket providers,
     * <code>RepositoryName</code> should include <code>WorkspaceName</code>. Use the format
     * <code>&lt;WorkspaceName&gt;/&lt;RepositoryName&gt;</code>.
     * </p>
     * 
     * @return The name of the remote repository that contains the job artifacts. For BitBucket providers,
     *         <code>RepositoryName</code> should include <code>WorkspaceName</code>. Use the format
     *         <code>&lt;WorkspaceName&gt;/&lt;RepositoryName&gt;</code>.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The owner of the remote repository that contains the job artifacts.
     * </p>
     * 
     * @return The owner of the remote repository that contains the job artifacts.
     */
    public final String repositoryOwner() {
        return repositoryOwner;
    }

    /**
     * <p>
     * An optional branch in the remote repository.
     * </p>
     * 
     * @return An optional branch in the remote repository.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * An optional folder in the remote repository.
     * </p>
     * 
     * @return An optional folder in the remote repository.
     */
    public final String folder() {
        return folder;
    }

    /**
     * <p>
     * A commit ID for a commit in the remote repository.
     * </p>
     * 
     * @return A commit ID for a commit in the remote repository.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets Manager,
     * or a personal access token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authStrategy} will
     * return {@link SourceControlAuthStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authStrategyAsString}.
     * </p>
     * 
     * @return The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
     *         Manager, or a personal access token.
     * @see SourceControlAuthStrategy
     */
    public final SourceControlAuthStrategy authStrategy() {
        return SourceControlAuthStrategy.fromValue(authStrategy);
    }

    /**
     * <p>
     * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets Manager,
     * or a personal access token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authStrategy} will
     * return {@link SourceControlAuthStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authStrategyAsString}.
     * </p>
     * 
     * @return The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
     *         Manager, or a personal access token.
     * @see SourceControlAuthStrategy
     */
    public final String authStrategyAsString() {
        return authStrategy;
    }

    /**
     * <p>
     * The value of the authorization token.
     * </p>
     * 
     * @return The value of the authorization token.
     */
    public final String authToken() {
        return authToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryOwner());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(folder());
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(authStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceControlFromJobRequest)) {
            return false;
        }
        UpdateSourceControlFromJobRequest other = (UpdateSourceControlFromJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(providerAsString(), other.providerAsString())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryOwner(), other.repositoryOwner()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(folder(), other.folder()) && Objects.equals(commitId(), other.commitId())
                && Objects.equals(authStrategyAsString(), other.authStrategyAsString())
                && Objects.equals(authToken(), other.authToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSourceControlFromJobRequest").add("JobName", jobName())
                .add("Provider", providerAsString()).add("RepositoryName", repositoryName())
                .add("RepositoryOwner", repositoryOwner()).add("BranchName", branchName()).add("Folder", folder())
                .add("CommitId", commitId()).add("AuthStrategy", authStrategyAsString()).add("AuthToken", authToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "RepositoryOwner":
            return Optional.ofNullable(clazz.cast(repositoryOwner()));
        case "BranchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "Folder":
            return Optional.ofNullable(clazz.cast(folder()));
        case "CommitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "AuthStrategy":
            return Optional.ofNullable(clazz.cast(authStrategyAsString()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceControlFromJobRequest, T> g) {
        return obj -> g.apply((UpdateSourceControlFromJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSourceControlFromJobRequest> {
        /**
         * <p>
         * The name of the Glue job to be synchronized to or from the remote repository.
         * </p>
         * 
         * @param jobName
         *        The name of the Glue job to be synchronized to or from the remote repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
         * </p>
         * 
         * @param provider
         *        The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
         * @see SourceControlProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
         * </p>
         * 
         * @param provider
         *        The provider for the remote repository. Possible values: GITHUB, AWS_CODE_COMMIT, GITLAB, BITBUCKET.
         * @see SourceControlProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlProvider
         */
        Builder provider(SourceControlProvider provider);

        /**
         * <p>
         * The name of the remote repository that contains the job artifacts. For BitBucket providers,
         * <code>RepositoryName</code> should include <code>WorkspaceName</code>. Use the format
         * <code>&lt;WorkspaceName&gt;/&lt;RepositoryName&gt;</code>.
         * </p>
         * 
         * @param repositoryName
         *        The name of the remote repository that contains the job artifacts. For BitBucket providers,
         *        <code>RepositoryName</code> should include <code>WorkspaceName</code>. Use the format
         *        <code>&lt;WorkspaceName&gt;/&lt;RepositoryName&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The owner of the remote repository that contains the job artifacts.
         * </p>
         * 
         * @param repositoryOwner
         *        The owner of the remote repository that contains the job artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryOwner(String repositoryOwner);

        /**
         * <p>
         * An optional branch in the remote repository.
         * </p>
         * 
         * @param branchName
         *        An optional branch in the remote repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * An optional folder in the remote repository.
         * </p>
         * 
         * @param folder
         *        An optional folder in the remote repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folder(String folder);

        /**
         * <p>
         * A commit ID for a commit in the remote repository.
         * </p>
         * 
         * @param commitId
         *        A commit ID for a commit in the remote repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         * Manager, or a personal access token.
         * </p>
         * 
         * @param authStrategy
         *        The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         *        Manager, or a personal access token.
         * @see SourceControlAuthStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlAuthStrategy
         */
        Builder authStrategy(String authStrategy);

        /**
         * <p>
         * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         * Manager, or a personal access token.
         * </p>
         * 
         * @param authStrategy
         *        The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         *        Manager, or a personal access token.
         * @see SourceControlAuthStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlAuthStrategy
         */
        Builder authStrategy(SourceControlAuthStrategy authStrategy);

        /**
         * <p>
         * The value of the authorization token.
         * </p>
         * 
         * @param authToken
         *        The value of the authorization token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String jobName;

        private String provider;

        private String repositoryName;

        private String repositoryOwner;

        private String branchName;

        private String folder;

        private String commitId;

        private String authStrategy;

        private String authToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceControlFromJobRequest model) {
            super(model);
            jobName(model.jobName);
            provider(model.provider);
            repositoryName(model.repositoryName);
            repositoryOwner(model.repositoryOwner);
            branchName(model.branchName);
            folder(model.folder);
            commitId(model.commitId);
            authStrategy(model.authStrategy);
            authToken(model.authToken);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(SourceControlProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryOwner() {
            return repositoryOwner;
        }

        public final void setRepositoryOwner(String repositoryOwner) {
            this.repositoryOwner = repositoryOwner;
        }

        @Override
        public final Builder repositoryOwner(String repositoryOwner) {
            this.repositoryOwner = repositoryOwner;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getFolder() {
            return folder;
        }

        public final void setFolder(String folder) {
            this.folder = folder;
        }

        @Override
        public final Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getAuthStrategy() {
            return authStrategy;
        }

        public final void setAuthStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
        }

        @Override
        public final Builder authStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
            return this;
        }

        @Override
        public final Builder authStrategy(SourceControlAuthStrategy authStrategy) {
            this.authStrategy(authStrategy == null ? null : authStrategy.toString());
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSourceControlFromJobRequest build() {
            return new UpdateSourceControlFromJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
