/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure specifying the dialect and dialect version used by the query engine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedDialect implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedDialect.Builder, SupportedDialect> {
    private static final SdkField<String> DIALECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Dialect")
            .getter(getter(SupportedDialect::dialectAsString)).setter(setter(Builder::dialect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dialect").build()).build();

    private static final SdkField<String> DIALECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DialectVersion").getter(getter(SupportedDialect::dialectVersion))
            .setter(setter(Builder::dialectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialectVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALECT_FIELD,
            DIALECT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dialect;

    private final String dialectVersion;

    private SupportedDialect(BuilderImpl builder) {
        this.dialect = builder.dialect;
        this.dialectVersion = builder.dialectVersion;
    }

    /**
     * <p>
     * The dialect of the query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return The dialect of the query engine.
     * @see ViewDialect
     */
    public final ViewDialect dialect() {
        return ViewDialect.fromValue(dialect);
    }

    /**
     * <p>
     * The dialect of the query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialect} will
     * return {@link ViewDialect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialectAsString}.
     * </p>
     * 
     * @return The dialect of the query engine.
     * @see ViewDialect
     */
    public final String dialectAsString() {
        return dialect;
    }

    /**
     * <p>
     * The version of the dialect of the query engine. For example, 3.0.0.
     * </p>
     * 
     * @return The version of the dialect of the query engine. For example, 3.0.0.
     */
    public final String dialectVersion() {
        return dialectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dialectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialectVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedDialect)) {
            return false;
        }
        SupportedDialect other = (SupportedDialect) obj;
        return Objects.equals(dialectAsString(), other.dialectAsString())
                && Objects.equals(dialectVersion(), other.dialectVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedDialect").add("Dialect", dialectAsString()).add("DialectVersion", dialectVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dialect":
            return Optional.ofNullable(clazz.cast(dialectAsString()));
        case "DialectVersion":
            return Optional.ofNullable(clazz.cast(dialectVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SupportedDialect, T> g) {
        return obj -> g.apply((SupportedDialect) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedDialect> {
        /**
         * <p>
         * The dialect of the query engine.
         * </p>
         * 
         * @param dialect
         *        The dialect of the query engine.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(String dialect);

        /**
         * <p>
         * The dialect of the query engine.
         * </p>
         * 
         * @param dialect
         *        The dialect of the query engine.
         * @see ViewDialect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewDialect
         */
        Builder dialect(ViewDialect dialect);

        /**
         * <p>
         * The version of the dialect of the query engine. For example, 3.0.0.
         * </p>
         * 
         * @param dialectVersion
         *        The version of the dialect of the query engine. For example, 3.0.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialectVersion(String dialectVersion);
    }

    static final class BuilderImpl implements Builder {
        private String dialect;

        private String dialectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedDialect model) {
            dialect(model.dialect);
            dialectVersion(model.dialectVersion);
        }

        public final String getDialect() {
            return dialect;
        }

        public final void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public final Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public final Builder dialect(ViewDialect dialect) {
            this.dialect(dialect == null ? null : dialect.toString());
            return this;
        }

        public final String getDialectVersion() {
            return dialectVersion;
        }

        public final void setDialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
        }

        @Override
        public final Builder dialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
            return this;
        }

        @Override
        public SupportedDialect build() {
            return new SupportedDialect(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
