/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBlueprintRunRequest extends GlueRequest implements
        ToCopyableBuilder<StartBlueprintRunRequest.Builder, StartBlueprintRunRequest> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintName").getter(getter(StartBlueprintRunRequest::blueprintName))
            .setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameters").getter(getter(StartBlueprintRunRequest::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(StartBlueprintRunRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD,
            PARAMETERS_FIELD, ROLE_ARN_FIELD));

    private final String blueprintName;

    private final String parameters;

    private final String roleArn;

    private StartBlueprintRunRequest(BuilderImpl builder) {
        super(builder);
        this.blueprintName = builder.blueprintName;
        this.parameters = builder.parameters;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the blueprint.
     * </p>
     * 
     * @return The name of the blueprint.
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * <p>
     * Specifies the parameters as a <code>BlueprintParameters</code> object.
     * </p>
     * 
     * @return Specifies the parameters as a <code>BlueprintParameters</code> object.
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * Specifies the IAM role used to create the workflow.
     * </p>
     * 
     * @return Specifies the IAM role used to create the workflow.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBlueprintRunRequest)) {
            return false;
        }
        StartBlueprintRunRequest other = (StartBlueprintRunRequest) obj;
        return Objects.equals(blueprintName(), other.blueprintName()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBlueprintRunRequest").add("BlueprintName", blueprintName()).add("Parameters", parameters())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBlueprintRunRequest, T> g) {
        return obj -> g.apply((StartBlueprintRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartBlueprintRunRequest> {
        /**
         * <p>
         * The name of the blueprint.
         * </p>
         * 
         * @param blueprintName
         *        The name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * <p>
         * Specifies the parameters as a <code>BlueprintParameters</code> object.
         * </p>
         * 
         * @param parameters
         *        Specifies the parameters as a <code>BlueprintParameters</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * Specifies the IAM role used to create the workflow.
         * </p>
         * 
         * @param roleArn
         *        Specifies the IAM role used to create the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String blueprintName;

        private String parameters;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBlueprintRunRequest model) {
            super(model);
            blueprintName(model.blueprintName);
            parameters(model.parameters);
            roleArn(model.roleArn);
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBlueprintRunRequest build() {
            return new StartBlueprintRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
