/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUnfilteredTableMetadataRequest extends GlueRequest implements
        ToCopyableBuilder<GetUnfilteredTableMetadataRequest.Builder, GetUnfilteredTableMetadataRequest> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(GetUnfilteredTableMetadataRequest::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetUnfilteredTableMetadataRequest::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetUnfilteredTableMetadataRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetUnfilteredTableMetadataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AuditContext> AUDIT_CONTEXT_FIELD = SdkField.<AuditContext> builder(MarshallingType.SDK_POJO)
            .memberName("AuditContext").getter(getter(GetUnfilteredTableMetadataRequest::auditContext))
            .setter(setter(Builder::auditContext)).constructor(AuditContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditContext").build()).build();

    private static final SdkField<List<String>> SUPPORTED_PERMISSION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedPermissionTypes")
            .getter(getter(GetUnfilteredTableMetadataRequest::supportedPermissionTypesAsStrings))
            .setter(setter(Builder::supportedPermissionTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPermissionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SupportedDialect> SUPPORTED_DIALECT_FIELD = SdkField
            .<SupportedDialect> builder(MarshallingType.SDK_POJO).memberName("SupportedDialect")
            .getter(getter(GetUnfilteredTableMetadataRequest::supportedDialect)).setter(setter(Builder::supportedDialect))
            .constructor(SupportedDialect::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedDialect").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(GetUnfilteredTableMetadataRequest::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QuerySessionContext> QUERY_SESSION_CONTEXT_FIELD = SdkField
            .<QuerySessionContext> builder(MarshallingType.SDK_POJO).memberName("QuerySessionContext")
            .getter(getter(GetUnfilteredTableMetadataRequest::querySessionContext)).setter(setter(Builder::querySessionContext))
            .constructor(QuerySessionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySessionContext").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            CATALOG_ID_FIELD, DATABASE_NAME_FIELD, NAME_FIELD, AUDIT_CONTEXT_FIELD, SUPPORTED_PERMISSION_TYPES_FIELD,
            SUPPORTED_DIALECT_FIELD, PERMISSIONS_FIELD, QUERY_SESSION_CONTEXT_FIELD));

    private final String region;

    private final String catalogId;

    private final String databaseName;

    private final String name;

    private final AuditContext auditContext;

    private final List<String> supportedPermissionTypes;

    private final SupportedDialect supportedDialect;

    private final List<String> permissions;

    private final QuerySessionContext querySessionContext;

    private GetUnfilteredTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.region = builder.region;
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.auditContext = builder.auditContext;
        this.supportedPermissionTypes = builder.supportedPermissionTypes;
        this.supportedDialect = builder.supportedDialect;
        this.permissions = builder.permissions;
        this.querySessionContext = builder.querySessionContext;
    }

    /**
     * <p>
     * Specified only if the base tables belong to a different Amazon Web Services Region.
     * </p>
     * 
     * @return Specified only if the base tables belong to a different Amazon Web Services Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The catalog ID where the table resides.
     * </p>
     * 
     * @return The catalog ID where the table resides.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * (Required) Specifies the name of a database that contains the table.
     * </p>
     * 
     * @return (Required) Specifies the name of a database that contains the table.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * (Required) Specifies the name of a table for which you are requesting metadata.
     * </p>
     * 
     * @return (Required) Specifies the name of a table for which you are requesting metadata.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A structure containing Lake Formation audit context information.
     * </p>
     * 
     * @return A structure containing Lake Formation audit context information.
     */
    public final AuditContext auditContext() {
        return auditContext;
    }

    /**
     * <p>
     * (Required) A list of supported permission types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPermissionTypes} method.
     * </p>
     * 
     * @return (Required) A list of supported permission types.
     */
    public final List<PermissionType> supportedPermissionTypes() {
        return PermissionTypeListCopier.copyStringToEnum(supportedPermissionTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedPermissionTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedPermissionTypes() {
        return supportedPermissionTypes != null && !(supportedPermissionTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Required) A list of supported permission types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPermissionTypes} method.
     * </p>
     * 
     * @return (Required) A list of supported permission types.
     */
    public final List<String> supportedPermissionTypesAsStrings() {
        return supportedPermissionTypes;
    }

    /**
     * <p>
     * A structure specifying the dialect and dialect version used by the query engine.
     * </p>
     * 
     * @return A structure specifying the dialect and dialect version used by the query engine.
     */
    public final SupportedDialect supportedDialect() {
        return supportedDialect;
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *         context is found.
     */
    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *         context is found.
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake Formation
     * generated authorization identifier and information from the request's authorization context.
     * </p>
     * 
     * @return A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
     *         Formation generated authorization identifier and information from the request's authorization context.
     */
    public final QuerySessionContext querySessionContext() {
        return querySessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(auditContext());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedPermissionTypes() ? supportedPermissionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(supportedDialect());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(querySessionContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataRequest)) {
            return false;
        }
        GetUnfilteredTableMetadataRequest other = (GetUnfilteredTableMetadataRequest) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(name(), other.name())
                && Objects.equals(auditContext(), other.auditContext())
                && hasSupportedPermissionTypes() == other.hasSupportedPermissionTypes()
                && Objects.equals(supportedPermissionTypesAsStrings(), other.supportedPermissionTypesAsStrings())
                && Objects.equals(supportedDialect(), other.supportedDialect()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && Objects.equals(querySessionContext(), other.querySessionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUnfilteredTableMetadataRequest").add("Region", region()).add("CatalogId", catalogId())
                .add("DatabaseName", databaseName()).add("Name", name()).add("AuditContext", auditContext())
                .add("SupportedPermissionTypes", hasSupportedPermissionTypes() ? supportedPermissionTypesAsStrings() : null)
                .add("SupportedDialect", supportedDialect()).add("Permissions", hasPermissions() ? permissionsAsStrings() : null)
                .add("QuerySessionContext", querySessionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AuditContext":
            return Optional.ofNullable(clazz.cast(auditContext()));
        case "SupportedPermissionTypes":
            return Optional.ofNullable(clazz.cast(supportedPermissionTypesAsStrings()));
        case "SupportedDialect":
            return Optional.ofNullable(clazz.cast(supportedDialect()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "QuerySessionContext":
            return Optional.ofNullable(clazz.cast(querySessionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredTableMetadataRequest, T> g) {
        return obj -> g.apply((GetUnfilteredTableMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetUnfilteredTableMetadataRequest> {
        /**
         * <p>
         * Specified only if the base tables belong to a different Amazon Web Services Region.
         * </p>
         * 
         * @param region
         *        Specified only if the base tables belong to a different Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The catalog ID where the table resides.
         * </p>
         * 
         * @param catalogId
         *        The catalog ID where the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * (Required) Specifies the name of a database that contains the table.
         * </p>
         * 
         * @param databaseName
         *        (Required) Specifies the name of a database that contains the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * (Required) Specifies the name of a table for which you are requesting metadata.
         * </p>
         * 
         * @param name
         *        (Required) Specifies the name of a table for which you are requesting metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure containing Lake Formation audit context information.
         * </p>
         * 
         * @param auditContext
         *        A structure containing Lake Formation audit context information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditContext(AuditContext auditContext);

        /**
         * <p>
         * A structure containing Lake Formation audit context information.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuditContext.Builder} avoiding the need
         * to create one manually via {@link AuditContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuditContext.Builder#build()} is called immediately and its
         * result is passed to {@link #auditContext(AuditContext)}.
         * 
         * @param auditContext
         *        a consumer that will call methods on {@link AuditContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditContext(AuditContext)
         */
        default Builder auditContext(Consumer<AuditContext.Builder> auditContext) {
            return auditContext(AuditContext.builder().applyMutation(auditContext).build());
        }

        /**
         * <p>
         * (Required) A list of supported permission types.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        (Required) A list of supported permission types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes);

        /**
         * <p>
         * (Required) A list of supported permission types.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        (Required) A list of supported permission types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypesWithStrings(String... supportedPermissionTypes);

        /**
         * <p>
         * (Required) A list of supported permission types.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        (Required) A list of supported permission types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes);

        /**
         * <p>
         * (Required) A list of supported permission types.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        (Required) A list of supported permission types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypes(PermissionType... supportedPermissionTypes);

        /**
         * <p>
         * A structure specifying the dialect and dialect version used by the query engine.
         * </p>
         * 
         * @param supportedDialect
         *        A structure specifying the dialect and dialect version used by the query engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDialect(SupportedDialect supportedDialect);

        /**
         * <p>
         * A structure specifying the dialect and dialect version used by the query engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link SupportedDialect.Builder} avoiding the
         * need to create one manually via {@link SupportedDialect#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupportedDialect.Builder#build()} is called immediately and its
         * result is passed to {@link #supportedDialect(SupportedDialect)}.
         * 
         * @param supportedDialect
         *        a consumer that will call methods on {@link SupportedDialect.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedDialect(SupportedDialect)
         */
        default Builder supportedDialect(Consumer<SupportedDialect.Builder> supportedDialect) {
            return supportedDialect(SupportedDialect.builder().applyMutation(supportedDialect).build());
        }

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
         * Formation generated authorization identifier and information from the request's authorization context.
         * </p>
         * 
         * @param querySessionContext
         *        A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
         *        Formation generated authorization identifier and information from the request's authorization context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder querySessionContext(QuerySessionContext querySessionContext);

        /**
         * <p>
         * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
         * Formation generated authorization identifier and information from the request's authorization context.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuerySessionContext.Builder} avoiding the
         * need to create one manually via {@link QuerySessionContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuerySessionContext.Builder#build()} is called immediately and
         * its result is passed to {@link #querySessionContext(QuerySessionContext)}.
         * 
         * @param querySessionContext
         *        a consumer that will call methods on {@link QuerySessionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #querySessionContext(QuerySessionContext)
         */
        default Builder querySessionContext(Consumer<QuerySessionContext.Builder> querySessionContext) {
            return querySessionContext(QuerySessionContext.builder().applyMutation(querySessionContext).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String region;

        private String catalogId;

        private String databaseName;

        private String name;

        private AuditContext auditContext;

        private List<String> supportedPermissionTypes = DefaultSdkAutoConstructList.getInstance();

        private SupportedDialect supportedDialect;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private QuerySessionContext querySessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredTableMetadataRequest model) {
            super(model);
            region(model.region);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            name(model.name);
            auditContext(model.auditContext);
            supportedPermissionTypesWithStrings(model.supportedPermissionTypes);
            supportedDialect(model.supportedDialect);
            permissionsWithStrings(model.permissions);
            querySessionContext(model.querySessionContext);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AuditContext.Builder getAuditContext() {
            return auditContext != null ? auditContext.toBuilder() : null;
        }

        public final void setAuditContext(AuditContext.BuilderImpl auditContext) {
            this.auditContext = auditContext != null ? auditContext.build() : null;
        }

        @Override
        public final Builder auditContext(AuditContext auditContext) {
            this.auditContext = auditContext;
            return this;
        }

        public final Collection<String> getSupportedPermissionTypes() {
            if (supportedPermissionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedPermissionTypes;
        }

        public final void setSupportedPermissionTypes(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
        }

        @Override
        public final Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypesWithStrings(String... supportedPermissionTypes) {
            supportedPermissionTypesWithStrings(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public final Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copyEnumToString(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypes(PermissionType... supportedPermissionTypes) {
            supportedPermissionTypes(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        public final SupportedDialect.Builder getSupportedDialect() {
            return supportedDialect != null ? supportedDialect.toBuilder() : null;
        }

        public final void setSupportedDialect(SupportedDialect.BuilderImpl supportedDialect) {
            this.supportedDialect = supportedDialect != null ? supportedDialect.build() : null;
        }

        @Override
        public final Builder supportedDialect(SupportedDialect supportedDialect) {
            this.supportedDialect = supportedDialect;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final QuerySessionContext.Builder getQuerySessionContext() {
            return querySessionContext != null ? querySessionContext.toBuilder() : null;
        }

        public final void setQuerySessionContext(QuerySessionContext.BuilderImpl querySessionContext) {
            this.querySessionContext = querySessionContext != null ? querySessionContext.build() : null;
        }

        @Override
        public final Builder querySessionContext(QuerySessionContext querySessionContext) {
            this.querySessionContext = querySessionContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUnfilteredTableMetadataRequest build() {
            return new GetUnfilteredTableMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
