/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a data quality result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityResultDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityResultDescription.Builder, DataQualityResultDescription> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultId").getter(getter(DataQualityResultDescription::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DataQualityResultDescription::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(DataQualityResultDescription::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobRunId").getter(getter(DataQualityResultDescription::jobRunId)).setter(setter(Builder::jobRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(DataQualityResultDescription::startedOn)).setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD,
            DATA_SOURCE_FIELD, JOB_NAME_FIELD, JOB_RUN_ID_FIELD, STARTED_ON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resultId;

    private final DataSource dataSource;

    private final String jobName;

    private final String jobRunId;

    private final Instant startedOn;

    private DataQualityResultDescription(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.dataSource = builder.dataSource;
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.startedOn = builder.startedOn;
    }

    /**
     * <p>
     * The unique result ID for this data quality result.
     * </p>
     * 
     * @return The unique result ID for this data quality result.
     */
    public final String resultId() {
        return resultId;
    }

    /**
     * <p>
     * The table name associated with the data quality result.
     * </p>
     * 
     * @return The table name associated with the data quality result.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The job name associated with the data quality result.
     * </p>
     * 
     * @return The job name associated with the data quality result.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job run ID associated with the data quality result.
     * </p>
     * 
     * @return The job run ID associated with the data quality result.
     */
    public final String jobRunId() {
        return jobRunId;
    }

    /**
     * <p>
     * The time that the run started for this data quality result.
     * </p>
     * 
     * @return The time that the run started for this data quality result.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityResultDescription)) {
            return false;
        }
        DataQualityResultDescription other = (DataQualityResultDescription) obj;
        return Objects.equals(resultId(), other.resultId()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobRunId(), other.jobRunId())
                && Objects.equals(startedOn(), other.startedOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityResultDescription").add("ResultId", resultId()).add("DataSource", dataSource())
                .add("JobName", jobName()).add("JobRunId", jobRunId()).add("StartedOn", startedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobRunId":
            return Optional.ofNullable(clazz.cast(jobRunId()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityResultDescription, T> g) {
        return obj -> g.apply((DataQualityResultDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityResultDescription> {
        /**
         * <p>
         * The unique result ID for this data quality result.
         * </p>
         * 
         * @param resultId
         *        The unique result ID for this data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);

        /**
         * <p>
         * The table name associated with the data quality result.
         * </p>
         * 
         * @param dataSource
         *        The table name associated with the data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The table name associated with the data quality result.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The job name associated with the data quality result.
         * </p>
         * 
         * @param jobName
         *        The job name associated with the data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job run ID associated with the data quality result.
         * </p>
         * 
         * @param jobRunId
         *        The job run ID associated with the data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunId(String jobRunId);

        /**
         * <p>
         * The time that the run started for this data quality result.
         * </p>
         * 
         * @param startedOn
         *        The time that the run started for this data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);
    }

    static final class BuilderImpl implements Builder {
        private String resultId;

        private DataSource dataSource;

        private String jobName;

        private String jobRunId;

        private Instant startedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityResultDescription model) {
            resultId(model.resultId);
            dataSource(model.dataSource);
            jobName(model.jobName);
            jobRunId(model.jobRunId);
            startedOn(model.startedOn);
        }

        public final String getResultId() {
            return resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobRunId() {
            return jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        @Override
        public DataQualityResultDescription build() {
            return new DataQualityResultDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
