/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 * <p>
 * For information about the underlying REST API, see <a
 * href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a>. For conceptual
 * information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working
 * with Archives in Amazon S3 Glacier</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteMultipartUploadResponse extends GlacierResponse implements
        ToCopyableBuilder<CompleteMultipartUploadResponse.Builder, CompleteMultipartUploadResponse> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(CompleteMultipartUploadResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(CompleteMultipartUploadResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-sha256-tree-hash").build())
            .build();

    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("archiveId").getter(getter(CompleteMultipartUploadResponse::archiveId))
            .setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-archive-id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            CHECKSUM_FIELD, ARCHIVE_ID_FIELD));

    private final String location;

    private final String checksum;

    private final String archiveId;

    private CompleteMultipartUploadResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.checksum = builder.checksum;
        this.archiveId = builder.archiveId;
    }

    /**
     * <p>
     * The relative URI path of the newly added archive resource.
     * </p>
     * 
     * @return The relative URI path of the newly added archive resource.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The checksum of the archive computed by Amazon S3 Glacier.
     * </p>
     * 
     * @return The checksum of the archive computed by Amazon S3 Glacier.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The ID of the archive. This value is also included as part of the location.
     * </p>
     * 
     * @return The ID of the archive. This value is also included as part of the location.
     */
    public final String archiveId() {
        return archiveId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartUploadResponse)) {
            return false;
        }
        CompleteMultipartUploadResponse other = (CompleteMultipartUploadResponse) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(archiveId(), other.archiveId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteMultipartUploadResponse").add("Location", location()).add("Checksum", checksum())
                .add("ArchiveId", archiveId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "archiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteMultipartUploadResponse, T> g) {
        return obj -> g.apply((CompleteMultipartUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, CompleteMultipartUploadResponse> {
        /**
         * <p>
         * The relative URI path of the newly added archive resource.
         * </p>
         * 
         * @param location
         *        The relative URI path of the newly added archive resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The checksum of the archive computed by Amazon S3 Glacier.
         * </p>
         * 
         * @param checksum
         *        The checksum of the archive computed by Amazon S3 Glacier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The ID of the archive. This value is also included as part of the location.
         * </p>
         * 
         * @param archiveId
         *        The ID of the archive. This value is also included as part of the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String location;

        private String checksum;

        private String archiveId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartUploadResponse model) {
            super(model);
            location(model.location);
            checksum(model.checksum);
            archiveId(model.archiveId);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getArchiveId() {
            return archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        @Override
        public CompleteMultipartUploadResponse build() {
            return new CompleteMultipartUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
