/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon FSx for NetApp ONTAP file system has the following endpoints that are used to access data or to manage the
 * file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSystemEndpoints implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSystemEndpoints.Builder, FileSystemEndpoints> {
    private static final SdkField<FileSystemEndpoint> INTERCLUSTER_FIELD = SdkField
            .<FileSystemEndpoint> builder(MarshallingType.SDK_POJO).memberName("Intercluster")
            .getter(getter(FileSystemEndpoints::intercluster)).setter(setter(Builder::intercluster))
            .constructor(FileSystemEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intercluster").build()).build();

    private static final SdkField<FileSystemEndpoint> MANAGEMENT_FIELD = SdkField
            .<FileSystemEndpoint> builder(MarshallingType.SDK_POJO).memberName("Management")
            .getter(getter(FileSystemEndpoints::management)).setter(setter(Builder::management))
            .constructor(FileSystemEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Management").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCLUSTER_FIELD,
            MANAGEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final FileSystemEndpoint intercluster;

    private final FileSystemEndpoint management;

    private FileSystemEndpoints(BuilderImpl builder) {
        this.intercluster = builder.intercluster;
        this.management = builder.management;
    }

    /**
     * <p>
     * An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems.
     * </p>
     * 
     * @return An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems.
     */
    public final FileSystemEndpoint intercluster() {
        return intercluster;
    }

    /**
     * <p>
     * An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API.
     * </p>
     * 
     * @return An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API.
     */
    public final FileSystemEndpoint management() {
        return management;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intercluster());
        hashCode = 31 * hashCode + Objects.hashCode(management());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemEndpoints)) {
            return false;
        }
        FileSystemEndpoints other = (FileSystemEndpoints) obj;
        return Objects.equals(intercluster(), other.intercluster()) && Objects.equals(management(), other.management());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSystemEndpoints").add("Intercluster", intercluster()).add("Management", management())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Intercluster":
            return Optional.ofNullable(clazz.cast(intercluster()));
        case "Management":
            return Optional.ofNullable(clazz.cast(management()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemEndpoints, T> g) {
        return obj -> g.apply((FileSystemEndpoints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSystemEndpoints> {
        /**
         * <p>
         * An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems.
         * </p>
         * 
         * @param intercluster
         *        An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intercluster(FileSystemEndpoint intercluster);

        /**
         * <p>
         * An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSystemEndpoint.Builder} avoiding the
         * need to create one manually via {@link FileSystemEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSystemEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #intercluster(FileSystemEndpoint)}.
         * 
         * @param intercluster
         *        a consumer that will call methods on {@link FileSystemEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intercluster(FileSystemEndpoint)
         */
        default Builder intercluster(Consumer<FileSystemEndpoint.Builder> intercluster) {
            return intercluster(FileSystemEndpoint.builder().applyMutation(intercluster).build());
        }

        /**
         * <p>
         * An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API.
         * </p>
         * 
         * @param management
         *        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder management(FileSystemEndpoint management);

        /**
         * <p>
         * An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSystemEndpoint.Builder} avoiding the
         * need to create one manually via {@link FileSystemEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSystemEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #management(FileSystemEndpoint)}.
         * 
         * @param management
         *        a consumer that will call methods on {@link FileSystemEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #management(FileSystemEndpoint)
         */
        default Builder management(Consumer<FileSystemEndpoint.Builder> management) {
            return management(FileSystemEndpoint.builder().applyMutation(management).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileSystemEndpoint intercluster;

        private FileSystemEndpoint management;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemEndpoints model) {
            intercluster(model.intercluster);
            management(model.management);
        }

        public final FileSystemEndpoint.Builder getIntercluster() {
            return intercluster != null ? intercluster.toBuilder() : null;
        }

        public final void setIntercluster(FileSystemEndpoint.BuilderImpl intercluster) {
            this.intercluster = intercluster != null ? intercluster.build() : null;
        }

        @Override
        public final Builder intercluster(FileSystemEndpoint intercluster) {
            this.intercluster = intercluster;
            return this;
        }

        public final FileSystemEndpoint.Builder getManagement() {
            return management != null ? management.toBuilder() : null;
        }

        public final void setManagement(FileSystemEndpoint.BuilderImpl management) {
            this.management = management != null ? management.build() : null;
        }

        @Override
        public final Builder management(FileSystemEndpoint management) {
            this.management = management;
            return this;
        }

        @Override
        public FileSystemEndpoints build() {
            return new FileSystemEndpoints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
