/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyResourcesExistForTagrisResponse extends FirehoseResponse implements
        ToCopyableBuilder<VerifyResourcesExistForTagrisResponse.Builder, VerifyResourcesExistForTagrisResponse> {
    private static final SdkField<Map<String, String>> TAGRIS_SWEEP_LIST_RESULT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TagrisSweepListResult")
            .getter(getter(VerifyResourcesExistForTagrisResponse::tagrisSweepListResultAsStrings))
            .setter(setter(Builder::tagrisSweepListResultWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisSweepListResult").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TAGRIS_SWEEP_LIST_RESULT_FIELD));

    private final Map<String, String> tagrisSweepListResult;

    private VerifyResourcesExistForTagrisResponse(BuilderImpl builder) {
        super(builder);
        this.tagrisSweepListResult = builder.tagrisSweepListResult;
    }

    /**
     * Returns the value of the TagrisSweepListResult property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagrisSweepListResult} method.
     * </p>
     * 
     * @return The value of the TagrisSweepListResult property for this object.
     */
    public final Map<String, TagrisStatus> tagrisSweepListResult() {
        return TagrisSweepListResultCopier.copyStringToEnum(tagrisSweepListResult);
    }

    /**
     * For responses, this returns true if the service returned a value for the TagrisSweepListResult property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTagrisSweepListResult() {
        return tagrisSweepListResult != null && !(tagrisSweepListResult instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the TagrisSweepListResult property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagrisSweepListResult} method.
     * </p>
     * 
     * @return The value of the TagrisSweepListResult property for this object.
     */
    public final Map<String, String> tagrisSweepListResultAsStrings() {
        return tagrisSweepListResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTagrisSweepListResult() ? tagrisSweepListResultAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyResourcesExistForTagrisResponse)) {
            return false;
        }
        VerifyResourcesExistForTagrisResponse other = (VerifyResourcesExistForTagrisResponse) obj;
        return hasTagrisSweepListResult() == other.hasTagrisSweepListResult()
                && Objects.equals(tagrisSweepListResultAsStrings(), other.tagrisSweepListResultAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyResourcesExistForTagrisResponse")
                .add("TagrisSweepListResult", hasTagrisSweepListResult() ? tagrisSweepListResultAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagrisSweepListResult":
            return Optional.ofNullable(clazz.cast(tagrisSweepListResultAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyResourcesExistForTagrisResponse, T> g) {
        return obj -> g.apply((VerifyResourcesExistForTagrisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyResourcesExistForTagrisResponse> {
        /**
         * Sets the value of the TagrisSweepListResult property for this object.
         *
         * @param tagrisSweepListResult
         *        The new value for the TagrisSweepListResult property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisSweepListResultWithStrings(Map<String, String> tagrisSweepListResult);

        /**
         * Sets the value of the TagrisSweepListResult property for this object.
         *
         * @param tagrisSweepListResult
         *        The new value for the TagrisSweepListResult property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisSweepListResult(Map<String, TagrisStatus> tagrisSweepListResult);
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private Map<String, String> tagrisSweepListResult = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyResourcesExistForTagrisResponse model) {
            super(model);
            tagrisSweepListResultWithStrings(model.tagrisSweepListResult);
        }

        public final Map<String, String> getTagrisSweepListResult() {
            if (tagrisSweepListResult instanceof SdkAutoConstructMap) {
                return null;
            }
            return tagrisSweepListResult;
        }

        public final void setTagrisSweepListResult(Map<String, String> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copy(tagrisSweepListResult);
        }

        @Override
        public final Builder tagrisSweepListResultWithStrings(Map<String, String> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copy(tagrisSweepListResult);
            return this;
        }

        @Override
        public final Builder tagrisSweepListResult(Map<String, TagrisStatus> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copyEnumToString(tagrisSweepListResult);
            return this;
        }

        @Override
        public VerifyResourcesExistForTagrisResponse build() {
            return new VerifyResourcesExistForTagrisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
