/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagrisSweepListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<TagrisSweepListItem.Builder, TagrisSweepListItem> {
    private static final SdkField<String> TAGRIS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagrisAccountId").getter(getter(TagrisSweepListItem::tagrisAccountId))
            .setter(setter(Builder::tagrisAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisAccountId").build()).build();

    private static final SdkField<String> TAGRIS_AMAZON_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagrisAmazonResourceName").getter(getter(TagrisSweepListItem::tagrisAmazonResourceName))
            .setter(setter(Builder::tagrisAmazonResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisAmazonResourceName").build())
            .build();

    private static final SdkField<String> TAGRIS_INTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagrisInternalId").getter(getter(TagrisSweepListItem::tagrisInternalId))
            .setter(setter(Builder::tagrisInternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisInternalId").build()).build();

    private static final SdkField<Long> TAGRIS_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TagrisVersion").getter(getter(TagrisSweepListItem::tagrisVersion))
            .setter(setter(Builder::tagrisVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGRIS_ACCOUNT_ID_FIELD,
            TAGRIS_AMAZON_RESOURCE_NAME_FIELD, TAGRIS_INTERNAL_ID_FIELD, TAGRIS_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tagrisAccountId;

    private final String tagrisAmazonResourceName;

    private final String tagrisInternalId;

    private final Long tagrisVersion;

    private TagrisSweepListItem(BuilderImpl builder) {
        this.tagrisAccountId = builder.tagrisAccountId;
        this.tagrisAmazonResourceName = builder.tagrisAmazonResourceName;
        this.tagrisInternalId = builder.tagrisInternalId;
        this.tagrisVersion = builder.tagrisVersion;
    }

    /**
     * Returns the value of the TagrisAccountId property for this object.
     * 
     * @return The value of the TagrisAccountId property for this object.
     */
    public final String tagrisAccountId() {
        return tagrisAccountId;
    }

    /**
     * Returns the value of the TagrisAmazonResourceName property for this object.
     * 
     * @return The value of the TagrisAmazonResourceName property for this object.
     */
    public final String tagrisAmazonResourceName() {
        return tagrisAmazonResourceName;
    }

    /**
     * Returns the value of the TagrisInternalId property for this object.
     * 
     * @return The value of the TagrisInternalId property for this object.
     */
    public final String tagrisInternalId() {
        return tagrisInternalId;
    }

    /**
     * Returns the value of the TagrisVersion property for this object.
     * 
     * @return The value of the TagrisVersion property for this object.
     */
    public final Long tagrisVersion() {
        return tagrisVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagrisAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(tagrisAmazonResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(tagrisInternalId());
        hashCode = 31 * hashCode + Objects.hashCode(tagrisVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagrisSweepListItem)) {
            return false;
        }
        TagrisSweepListItem other = (TagrisSweepListItem) obj;
        return Objects.equals(tagrisAccountId(), other.tagrisAccountId())
                && Objects.equals(tagrisAmazonResourceName(), other.tagrisAmazonResourceName())
                && Objects.equals(tagrisInternalId(), other.tagrisInternalId())
                && Objects.equals(tagrisVersion(), other.tagrisVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagrisSweepListItem").add("TagrisAccountId", tagrisAccountId())
                .add("TagrisAmazonResourceName", tagrisAmazonResourceName()).add("TagrisInternalId", tagrisInternalId())
                .add("TagrisVersion", tagrisVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagrisAccountId":
            return Optional.ofNullable(clazz.cast(tagrisAccountId()));
        case "TagrisAmazonResourceName":
            return Optional.ofNullable(clazz.cast(tagrisAmazonResourceName()));
        case "TagrisInternalId":
            return Optional.ofNullable(clazz.cast(tagrisInternalId()));
        case "TagrisVersion":
            return Optional.ofNullable(clazz.cast(tagrisVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagrisSweepListItem, T> g) {
        return obj -> g.apply((TagrisSweepListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagrisSweepListItem> {
        /**
         * Sets the value of the TagrisAccountId property for this object.
         *
         * @param tagrisAccountId
         *        The new value for the TagrisAccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisAccountId(String tagrisAccountId);

        /**
         * Sets the value of the TagrisAmazonResourceName property for this object.
         *
         * @param tagrisAmazonResourceName
         *        The new value for the TagrisAmazonResourceName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisAmazonResourceName(String tagrisAmazonResourceName);

        /**
         * Sets the value of the TagrisInternalId property for this object.
         *
         * @param tagrisInternalId
         *        The new value for the TagrisInternalId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisInternalId(String tagrisInternalId);

        /**
         * Sets the value of the TagrisVersion property for this object.
         *
         * @param tagrisVersion
         *        The new value for the TagrisVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisVersion(Long tagrisVersion);
    }

    static final class BuilderImpl implements Builder {
        private String tagrisAccountId;

        private String tagrisAmazonResourceName;

        private String tagrisInternalId;

        private Long tagrisVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TagrisSweepListItem model) {
            tagrisAccountId(model.tagrisAccountId);
            tagrisAmazonResourceName(model.tagrisAmazonResourceName);
            tagrisInternalId(model.tagrisInternalId);
            tagrisVersion(model.tagrisVersion);
        }

        public final String getTagrisAccountId() {
            return tagrisAccountId;
        }

        public final void setTagrisAccountId(String tagrisAccountId) {
            this.tagrisAccountId = tagrisAccountId;
        }

        @Override
        public final Builder tagrisAccountId(String tagrisAccountId) {
            this.tagrisAccountId = tagrisAccountId;
            return this;
        }

        public final String getTagrisAmazonResourceName() {
            return tagrisAmazonResourceName;
        }

        public final void setTagrisAmazonResourceName(String tagrisAmazonResourceName) {
            this.tagrisAmazonResourceName = tagrisAmazonResourceName;
        }

        @Override
        public final Builder tagrisAmazonResourceName(String tagrisAmazonResourceName) {
            this.tagrisAmazonResourceName = tagrisAmazonResourceName;
            return this;
        }

        public final String getTagrisInternalId() {
            return tagrisInternalId;
        }

        public final void setTagrisInternalId(String tagrisInternalId) {
            this.tagrisInternalId = tagrisInternalId;
        }

        @Override
        public final Builder tagrisInternalId(String tagrisInternalId) {
            this.tagrisInternalId = tagrisInternalId;
            return this;
        }

        public final Long getTagrisVersion() {
            return tagrisVersion;
        }

        public final void setTagrisVersion(Long tagrisVersion) {
            this.tagrisVersion = tagrisVersion;
        }

        @Override
        public final Builder tagrisVersion(Long tagrisVersion) {
            this.tagrisVersion = tagrisVersion;
            return this;
        }

        @Override
        public TagrisSweepListItem build() {
            return new TagrisSweepListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
