/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagrisPartialResourcesExistResultsException extends FirehoseException implements
        ToCopyableBuilder<TagrisPartialResourcesExistResultsException.Builder, TagrisPartialResourcesExistResultsException> {
    private static final SdkField<Map<String, String>> RESOURCE_EXISTENCE_INFORMATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("resourceExistenceInformation")
            .getter(getter(TagrisPartialResourcesExistResultsException::resourceExistenceInformationAsStrings))
            .setter(setter(Builder::resourceExistenceInformationWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceExistenceInformation")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOURCE_EXISTENCE_INFORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> resourceExistenceInformation;

    private TagrisPartialResourcesExistResultsException(BuilderImpl builder) {
        super(builder);
        this.resourceExistenceInformation = builder.resourceExistenceInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ResourceExistenceInformation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceExistenceInformation} method.
     * </p>
     * 
     * @return The value of the ResourceExistenceInformation property for this object.
     */
    public Map<String, TagrisStatus> resourceExistenceInformation() {
        return TagrisSweepListResultCopier.copyStringToEnum(resourceExistenceInformation);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceExistenceInformation property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public boolean hasResourceExistenceInformation() {
        return resourceExistenceInformation != null && !(resourceExistenceInformation instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the ResourceExistenceInformation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceExistenceInformation} method.
     * </p>
     * 
     * @return The value of the ResourceExistenceInformation property for this object.
     */
    public Map<String, String> resourceExistenceInformationAsStrings() {
        return resourceExistenceInformation;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagrisPartialResourcesExistResultsException, T> g) {
        return obj -> g.apply((TagrisPartialResourcesExistResultsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagrisPartialResourcesExistResultsException>,
            FirehoseException.Builder {
        /**
         * Sets the value of the ResourceExistenceInformation property for this object.
         *
         * @param resourceExistenceInformation
         *        The new value for the ResourceExistenceInformation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceExistenceInformationWithStrings(Map<String, String> resourceExistenceInformation);

        /**
         * Sets the value of the ResourceExistenceInformation property for this object.
         *
         * @param resourceExistenceInformation
         *        The new value for the ResourceExistenceInformation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceExistenceInformation(Map<String, TagrisStatus> resourceExistenceInformation);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends FirehoseException.BuilderImpl implements Builder {
        private Map<String, String> resourceExistenceInformation = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagrisPartialResourcesExistResultsException model) {
            super(model);
            resourceExistenceInformationWithStrings(model.resourceExistenceInformation);
        }

        public final Map<String, String> getResourceExistenceInformation() {
            if (resourceExistenceInformation instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceExistenceInformation;
        }

        public final void setResourceExistenceInformation(Map<String, String> resourceExistenceInformation) {
            this.resourceExistenceInformation = TagrisSweepListResultCopier.copy(resourceExistenceInformation);
        }

        @Override
        public final Builder resourceExistenceInformationWithStrings(Map<String, String> resourceExistenceInformation) {
            this.resourceExistenceInformation = TagrisSweepListResultCopier.copy(resourceExistenceInformation);
            return this;
        }

        @Override
        public final Builder resourceExistenceInformation(Map<String, TagrisStatus> resourceExistenceInformation) {
            this.resourceExistenceInformation = TagrisSweepListResultCopier.copyEnumToString(resourceExistenceInformation);
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public TagrisPartialResourcesExistResultsException build() {
            return new TagrisPartialResourcesExistResultsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
